/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.scanner;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.instrument.scanner.Scanner;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarFileScanner
implements Scanner {
    private final JarFile jarFile;

    public JarFileScanner(String path) {
        Assert.requireNonNull((Object)path, (String)"path must not be null");
        try {
            this.jarFile = new JarFile(path);
        }
        catch (IOException e) {
            throw new IllegalStateException(path + " create fail");
        }
    }

    @Override
    public boolean exist(String fileName) {
        JarEntry jarEntry = this.jarFile.getJarEntry(fileName);
        return jarEntry != null;
    }

    @Override
    public InputStream openStream(String fileName) {
        JarEntry jarEntry = this.jarFile.getJarEntry(fileName);
        if (jarEntry == null) {
            return null;
        }
        try {
            return this.jarFile.getInputStream(jarEntry);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void close() {
        if (this.jarFile != null) {
            try {
                this.jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "JarFileScanner{jarFile=" + this.jarFile.getName() + '}';
    }
}

