/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import java.util.ArrayList;
import java.util.List;

public class SpanStorage
implements Storage {
    protected List<SpanEvent> spanEventList = new ArrayList<SpanEvent>(10);
    private final TraceRoot traceRoot;
    private final DataSender dataSender;

    public SpanStorage(TraceRoot traceRoot, DataSender dataSender) {
        if (traceRoot == null) {
            throw new NullPointerException("traceRoot must not be null");
        }
        if (dataSender == null) {
            throw new NullPointerException("dataSender must not be null");
        }
        this.traceRoot = traceRoot;
        this.dataSender = dataSender;
    }

    @Override
    public void store(SpanEvent spanEvent) {
        if (spanEvent == null) {
            throw new NullPointerException("spanEvent must not be null");
        }
        List<SpanEvent> spanEventList = this.spanEventList;
        if (spanEventList == null) {
            throw new IllegalStateException("spanEventList is null");
        }
        spanEventList.add(spanEvent);
    }

    @Override
    public void store(Span span) {
        if (span == null) {
            throw new NullPointerException("span must not be null");
        }
        span.setSpanEventList(this.spanEventList);
        this.spanEventList = null;
        this.dataSender.send(span);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

