/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.jvmgc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.jvmgc.BasicJvmGcMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.jvmgc.DetailedJvmGcMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.DetailedGarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.GarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.DetailedMemoryMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.MemoryMetric;
import com.navercorp.pinpoint.thrift.dto.TJvmGc;

public class JvmGcMetricCollectorProvider
implements Provider<AgentStatMetricCollector<TJvmGc>> {
    private final boolean collectDetailedMetrics;
    private final Provider<MemoryMetric> memoryMetricProivider;
    private final Provider<DetailedMemoryMetric> detailedMemoryMetricProvider;
    private final Provider<GarbageCollectorMetric> garbageCollectorMetricProvider;
    private final Provider<DetailedGarbageCollectorMetric> detailedGarbageCollectorMetricProvider;

    @Inject
    public JvmGcMetricCollectorProvider(ProfilerConfig profilerConfig, Provider<MemoryMetric> memoryMetricProivider, Provider<DetailedMemoryMetric> detailedMemoryMetricProvider, Provider<GarbageCollectorMetric> garbageCollectorMetricProvider, Provider<DetailedGarbageCollectorMetric> detailedGarbageCollectorMetricProvider) {
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        if (memoryMetricProivider == null) {
            throw new NullPointerException("memoryMetricProivider must not be null");
        }
        if (detailedMemoryMetricProvider == null) {
            throw new NullPointerException("detailedMemoryMetricProvider must not be null");
        }
        if (garbageCollectorMetricProvider == null) {
            throw new NullPointerException("garbageCollectorMetricProvider must not be null");
        }
        if (detailedGarbageCollectorMetricProvider == null) {
            throw new NullPointerException("detailedGarbageCollectorMetricProvider must not be null");
        }
        this.collectDetailedMetrics = profilerConfig.isProfilerJvmStatCollectDetailedMetrics();
        this.memoryMetricProivider = memoryMetricProivider;
        this.detailedMemoryMetricProvider = detailedMemoryMetricProvider;
        this.garbageCollectorMetricProvider = garbageCollectorMetricProvider;
        this.detailedGarbageCollectorMetricProvider = detailedGarbageCollectorMetricProvider;
    }

    public AgentStatMetricCollector<TJvmGc> get() {
        MemoryMetric memoryMetric = (MemoryMetric)this.memoryMetricProivider.get();
        GarbageCollectorMetric garbageCollectorMetric = (GarbageCollectorMetric)this.garbageCollectorMetricProvider.get();
        BasicJvmGcMetricCollector jvmGcMetricCollector = new BasicJvmGcMetricCollector(memoryMetric, garbageCollectorMetric);
        if (this.collectDetailedMetrics) {
            DetailedMemoryMetric detailedMemoryMetric = (DetailedMemoryMetric)this.detailedMemoryMetricProvider.get();
            DetailedGarbageCollectorMetric detailedGarbageCollectorMetric = (DetailedGarbageCollectorMetric)this.detailedGarbageCollectorMetricProvider.get();
            return new DetailedJvmGcMetricCollector(jvmGcMetricCollector, detailedMemoryMetric, detailedGarbageCollectorMetric);
        }
        return jvmGcMetricCollector;
    }
}

