/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.ServerMetaDataHolder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcContext;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.context.AsyncTraceContext;
import com.navercorp.pinpoint.profiler.context.DefaultTraceContext;
import com.navercorp.pinpoint.profiler.context.TraceFactory;
import com.navercorp.pinpoint.profiler.context.id.TraceIdFactory;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;

public class TraceContextProvider
implements Provider<TraceContext> {
    private final ProfilerConfig profilerConfig;
    private final Provider<AgentInformation> agentInformationProvider;
    private final TraceIdFactory traceIdFactory;
    private final TraceFactory traceFactory;
    private final AsyncTraceContext asyncTraceContext;
    private final ServerMetaDataHolder serverMetaDataHolder;
    private final ApiMetaDataService apiMetaDataService;
    private final StringMetaDataService stringMetaDataService;
    private final SqlMetaDataService sqlMetaDataService;
    private final JdbcContext jdbcContext;

    @Inject
    public TraceContextProvider(ProfilerConfig profilerConfig, Provider<AgentInformation> agentInformationProvider, TraceIdFactory traceIdFactory, TraceFactory traceFactory, AsyncTraceContext asyncTraceContext, ServerMetaDataHolder serverMetaDataHolder, ApiMetaDataService apiMetaDataService, StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaDataService, JdbcContext jdbcContext) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.agentInformationProvider = (Provider)Assert.requireNonNull(agentInformationProvider, (String)"agentInformationProvider must not be null");
        this.traceIdFactory = (TraceIdFactory)Assert.requireNonNull((Object)traceIdFactory, (String)"traceIdFactory must not be null");
        this.traceFactory = (TraceFactory)Assert.requireNonNull((Object)traceFactory, (String)"traceFactory must not be null");
        this.asyncTraceContext = (AsyncTraceContext)Assert.requireNonNull((Object)asyncTraceContext, (String)"asyncTraceContext must not be null");
        this.serverMetaDataHolder = (ServerMetaDataHolder)Assert.requireNonNull((Object)serverMetaDataHolder, (String)"serverMetaDataHolder must not be null");
        this.apiMetaDataService = (ApiMetaDataService)Assert.requireNonNull((Object)apiMetaDataService, (String)"apiMetaDataService must not be null");
        this.stringMetaDataService = (StringMetaDataService)Assert.requireNonNull((Object)stringMetaDataService, (String)"stringMetaDataService must not be null");
        this.sqlMetaDataService = (SqlMetaDataService)Assert.requireNonNull((Object)sqlMetaDataService, (String)"sqlMetaDataService must not be null");
        this.jdbcContext = (JdbcContext)Assert.requireNonNull((Object)jdbcContext, (String)"jdbcContext must not be null");
    }

    public TraceContext get() {
        AgentInformation agentInformation = (AgentInformation)this.agentInformationProvider.get();
        return new DefaultTraceContext(this.profilerConfig, agentInformation, this.traceIdFactory, this.traceFactory, this.asyncTraceContext, this.serverMetaDataHolder, this.apiMetaDataService, this.stringMetaDataService, this.sqlMetaDataService, this.jdbcContext);
    }
}

