/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.common.plugin.PluginLoader;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.BootstrapCore;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjectorFactory;
import com.navercorp.pinpoint.profiler.plugin.DefaultPluginContextLoadResult;
import com.navercorp.pinpoint.profiler.plugin.PluginContextLoadResult;

public class PluginContextLoadResultProvider
implements Provider<PluginContextLoadResult> {
    private final ProfilerConfig profilerConfig;
    private final InstrumentEngine instrumentEngine;
    private final DynamicTransformTrigger dynamicTransformTrigger;
    private final PluginLoader pluginLoader;
    private final BootstrapCore bootstrapCore;

    @Inject
    public PluginContextLoadResultProvider(ProfilerConfig profilerConfig, DynamicTransformTrigger dynamicTransformTrigger, InstrumentEngine instrumentEngine, PluginLoader pluginLoader, BootstrapCore bootstrapCore) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.dynamicTransformTrigger = (DynamicTransformTrigger)Assert.requireNonNull((Object)dynamicTransformTrigger, (String)"dynamicTransformTrigger must not be null");
        this.instrumentEngine = (InstrumentEngine)Assert.requireNonNull((Object)instrumentEngine, (String)"instrumentEngine must not be null");
        this.pluginLoader = (PluginLoader)Assert.requireNonNull((Object)pluginLoader, (String)"pluginLoader must not be null");
        this.bootstrapCore = (BootstrapCore)Assert.requireNonNull((Object)bootstrapCore, (String)"bootstrapCore must not be null");
    }

    public PluginContextLoadResult get() {
        ClassInjectorFactory classInjectorFactory = new ClassInjectorFactory(this.instrumentEngine, this.bootstrapCore);
        return new DefaultPluginContextLoadResult(this.profilerConfig, this.dynamicTransformTrigger, this.instrumentEngine, this.pluginLoader, classInjectorFactory);
    }
}

