/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.AsyncTraceContext;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.Binder;
import com.navercorp.pinpoint.profiler.context.DefaultAsyncTraceContext;
import com.navercorp.pinpoint.profiler.context.id.AsyncIdGenerator;

public class AsyncTraceContextProvider
implements Provider<AsyncTraceContext> {
    private final AsyncIdGenerator asyncIdGenerator;
    private Provider<BaseTraceFactory> baseTraceFactoryProvider;
    private final Binder<Trace> binder;

    @Inject
    public AsyncTraceContextProvider(AsyncIdGenerator asyncIdGenerator, Binder<Trace> binder) {
        this.asyncIdGenerator = (AsyncIdGenerator)Assert.requireNonNull((Object)asyncIdGenerator, (String)"asyncIdGenerator must not be null");
        this.binder = (Binder)Assert.requireNonNull(binder, (String)"binder must not be null");
    }

    @Inject
    public void setBaseTraceFactoryProvider(Provider<BaseTraceFactory> baseTraceFactoryProvider) {
        this.baseTraceFactoryProvider = (Provider)Assert.requireNonNull(baseTraceFactoryProvider, (String)"baseTraceFactoryProvider must not be null");
    }

    public AsyncTraceContext get() {
        Assert.requireNonNull((Object)this.asyncIdGenerator, (String)"asyncIdGenerator must not be null");
        return new DefaultAsyncTraceContext(this.baseTraceFactoryProvider, this.asyncIdGenerator, this.binder);
    }
}

