/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.active.DefaultActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.active.EmptyActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.module.config.TraceAgentActiveThread;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeCollector;

public class ActiveTraceRepositoryProvider
implements Provider<ActiveTraceRepository> {
    private boolean isTraceAgentActiveThread;
    private final ResponseTimeCollector responseTimeCollector;

    @Inject
    public ActiveTraceRepositoryProvider(@TraceAgentActiveThread boolean isTraceAgentActiveThread, ResponseTimeCollector responseTimeCollector) {
        this.isTraceAgentActiveThread = isTraceAgentActiveThread;
        this.responseTimeCollector = (ResponseTimeCollector)Assert.requireNonNull((Object)responseTimeCollector, (String)"responseTimeCollector must not be null");
    }

    public ActiveTraceRepository get() {
        if (this.isTraceAgentActiveThread) {
            return new DefaultActiveTraceRepository(this.responseTimeCollector);
        }
        EmptyActiveTraceRepository emptyActiveTraceRepository = new EmptyActiveTraceRepository(this.responseTimeCollector);
        return emptyActiveTraceRepository;
    }
}

