/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.active;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceSnapshot;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;

public class SampledActiveTraceSnapshot
implements ActiveTraceSnapshot {
    private final TraceRoot traceRoot;

    public SampledActiveTraceSnapshot(TraceRoot traceRoot) {
        this.traceRoot = (TraceRoot)Assert.requireNonNull((Object)traceRoot, (String)"traceRoot must not be null");
    }

    @Override
    public long getLocalTransactionId() {
        return this.traceRoot.getLocalTransactionId();
    }

    @Override
    public long getStartTime() {
        return this.traceRoot.getTraceStartTime();
    }

    @Override
    public long getThreadId() {
        return this.traceRoot.getShared().getThreadId();
    }

    @Override
    public boolean isSampled() {
        return true;
    }

    @Override
    public String getTransactionId() {
        return this.traceRoot.getTraceId().getTransactionId();
    }

    @Override
    public String getEntryPoint() {
        return this.traceRoot.getShared().getRpcName();
    }

    public String toString() {
        return "SampledActiveTraceSnapshot{traceRoot=" + this.traceRoot + '}';
    }
}

