/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.bootstrap.agentdir.AgentDirectory;
import com.navercorp.pinpoint.bootstrap.agentdir.BootDir;
import com.navercorp.pinpoint.bootstrap.agentdir.ClassPathResolver;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentDirBaseClassPathResolver
implements ClassPathResolver {
    private final BootLogger logger = BootLogger.getLogger(this.getClass().getName());
    static final String VERSION_PATTERN = "(-[0-9]+\\.[0-9]+\\.[0-9]+((\\-SNAPSHOT)|(-RC[0-9]+))?)?";
    static final Pattern DEFAULT_AGENT_BOOTSTRAP_PATTERN = AgentDirBaseClassPathResolver.compile("pinpoint-bootstrap(-[0-9]+\\.[0-9]+\\.[0-9]+((\\-SNAPSHOT)|(-RC[0-9]+))?)?\\.jar");
    static final Pattern DEFAULT_AGENT_COMMONS_PATTERN = AgentDirBaseClassPathResolver.compile("pinpoint-commons(-[0-9]+\\.[0-9]+\\.[0-9]+((\\-SNAPSHOT)|(-RC[0-9]+))?)?\\.jar");
    static final Pattern DEFAULT_AGENT_CORE_PATTERN = AgentDirBaseClassPathResolver.compile("pinpoint-bootstrap-core(-[0-9]+\\.[0-9]+\\.[0-9]+((\\-SNAPSHOT)|(-RC[0-9]+))?)?\\.jar");
    static final Pattern DEFAULT_AGENT_JAVA8_PATTERN = AgentDirBaseClassPathResolver.compile("pinpoint-bootstrap-java8(-[0-9]+\\.[0-9]+\\.[0-9]+((\\-SNAPSHOT)|(-RC[0-9]+))?)?\\.jar");
    static final Pattern DEFAULT_AGENT_JAVA9_PATTERN = AgentDirBaseClassPathResolver.compile("pinpoint-bootstrap-java9(-[0-9]+\\.[0-9]+\\.[0-9]+((\\-SNAPSHOT)|(-RC[0-9]+))?)?\\.jar");
    static final Pattern DEFAULT_AGENT_CORE_OPTIONAL_PATTERN = AgentDirBaseClassPathResolver.compile("pinpoint-bootstrap-core-optional(-[0-9]+\\.[0-9]+\\.[0-9]+((\\-SNAPSHOT)|(-RC[0-9]+))?)?\\.jar");
    static final Pattern DEFAULT_ANNOTATIONS = AgentDirBaseClassPathResolver.compile("pinpoint-annotations(-[0-9]+\\.[0-9]+\\.[0-9]+((\\-SNAPSHOT)|(-RC[0-9]+))?)?\\.jar");
    private final Pattern agentBootstrapPattern;
    private final Pattern agentCommonsPattern;
    private final Pattern agentCorePattern;
    private final Pattern agentJava8Pattern;
    private final Pattern agentJava9Pattern;
    private final Pattern agentCoreOptionalPattern;
    private final Pattern annotationsPattern;
    private final String classPath;
    private List<String> fileExtensionList;

    private static Pattern compile(String regex) {
        return Pattern.compile(regex);
    }

    public AgentDirBaseClassPathResolver(String classPath) {
        if (classPath == null) {
            throw new NullPointerException("classPath must not be null");
        }
        this.classPath = classPath;
        this.agentBootstrapPattern = DEFAULT_AGENT_BOOTSTRAP_PATTERN;
        this.agentCommonsPattern = DEFAULT_AGENT_COMMONS_PATTERN;
        this.agentCorePattern = DEFAULT_AGENT_CORE_PATTERN;
        this.agentJava8Pattern = DEFAULT_AGENT_JAVA8_PATTERN;
        this.agentJava9Pattern = DEFAULT_AGENT_JAVA9_PATTERN;
        this.agentCoreOptionalPattern = DEFAULT_AGENT_CORE_OPTIONAL_PATTERN;
        this.annotationsPattern = DEFAULT_ANNOTATIONS;
        this.fileExtensionList = AgentDirBaseClassPathResolver.getDefaultFileExtensionList();
    }

    static List<String> getDefaultFileExtensionList() {
        ArrayList<String> extensionList = new ArrayList<String>(3);
        extensionList.add("jar");
        extensionList.add("xml");
        extensionList.add("properties");
        return extensionList;
    }

    @Override
    public AgentDirectory resolve() {
        String bootstrapJarName = this.findBootstrapJar(this.classPath);
        if (bootstrapJarName == null) {
            throw new IllegalStateException("pinpoint-bootstrap-x.x.x(-SNAPSHOT).jar not found.");
        }
        String agentJarFullPath = this.parseAgentJarPath(this.classPath, bootstrapJarName);
        if (agentJarFullPath == null) {
            throw new IllegalStateException("pinpoint-bootstrap-x.x.x(-SNAPSHOT).jar not found. " + this.classPath);
        }
        String agentDirPath = this.getAgentDirPath(agentJarFullPath);
        BootDir bootDir = this.resolveBootDir(agentDirPath);
        String agentLibPath = this.getAgentLibPath(agentDirPath);
        List<URL> libs = this.resolveLib(agentLibPath, bootDir);
        String agentPluginPath = this.getAgentPluginPath(agentDirPath);
        List<String> plugins = this.resolvePlugins(agentPluginPath);
        AgentDirectory agentDirectory = new AgentDirectory(bootstrapJarName, agentJarFullPath, agentDirPath, bootDir, libs, plugins);
        return agentDirectory;
    }

    private String getAgentDirPath(String agentJarFullPath) {
        String agentDirPath = this.parseAgentDirPath(agentJarFullPath);
        if (agentDirPath == null) {
            throw new IllegalStateException("agentDirPath is null " + this.classPath);
        }
        this.logger.info("Agent original-path:" + agentDirPath);
        agentDirPath = this.toCanonicalPath(agentDirPath);
        this.logger.info("Agent canonical-path:" + agentDirPath);
        return agentDirPath;
    }

    private BootDir resolveBootDir(String agentDirPath) {
        String bootDirPath = agentDirPath + File.separator + "boot";
        String pinpointCommonsJar = this.find(bootDirPath, "pinpoint-commons.jar", this.agentCommonsPattern);
        String bootStrapCoreJar = this.find(bootDirPath, "pinpoint-bootstrap-core.jar", this.agentCorePattern);
        String bootStrapJava8Jar = this.find(bootDirPath, "pinpoint-bootstrap-java8.jar", this.agentJava8Pattern);
        String bootStrapJava9Jar = this.find(bootDirPath, "pinpoint-bootstrap-java9.jar", this.agentJava9Pattern);
        String bootStrapCoreOptionalJar = this.find(bootDirPath, "pinpoint-bootstrap-core-optional.jar", this.agentCoreOptionalPattern);
        String annotationsJar = this.find(bootDirPath, "pinpoint-annotations.jar", this.annotationsPattern);
        return new BootDir(pinpointCommonsJar, bootStrapCoreJar, bootStrapCoreOptionalJar, bootStrapJava8Jar, bootStrapJava9Jar, annotationsJar);
    }

    String findBootstrapJar(String classPath) {
        Matcher matcher = this.agentBootstrapPattern.matcher(classPath);
        if (!matcher.find()) {
            return null;
        }
        return this.parseAgentJar(matcher, classPath);
    }

    private String toCanonicalPath(String path) {
        File file = new File(path);
        return this.toCanonicalPath(file);
    }

    private String toCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            this.logger.warn(file.getPath() + " getCanonicalPath() error. Error:" + e.getMessage(), e);
            return file.getAbsolutePath();
        }
    }

    private String find(String bootDirPath, String name, Pattern pattern) {
        Object[] files = this.listFiles(name, pattern, bootDirPath);
        if (this.isEmpty((File[])files)) {
            this.logger.info(name + " not found.");
            return null;
        }
        if (files.length == 1) {
            File file = files[0];
            return this.toCanonicalPath(file);
        }
        this.logger.info("too many " + name + " found. " + Arrays.toString(files));
        return null;
    }

    private boolean isEmpty(File[] files) {
        return files == null || files.length == 0;
    }

    private File[] listFiles(final String name, final Pattern pattern, String bootDirPath) {
        File bootDir = new File(bootDirPath);
        return bootDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                Matcher matcher = pattern.matcher(fileName);
                if (matcher.matches()) {
                    AgentDirBaseClassPathResolver.this.logger.info("found " + name + ". " + dir.getAbsolutePath() + File.separator + fileName);
                    return true;
                }
                return false;
            }
        });
    }

    private String parseAgentJar(Matcher matcher, String classpath) {
        int start = matcher.start();
        int end = matcher.end();
        return this.classPath.substring(start, end);
    }

    private String parseAgentJarPath(String classPath, String agentJar) {
        String[] classPathList;
        for (String findPath : classPathList = classPath.split(File.pathSeparator)) {
            boolean find = findPath.contains(agentJar);
            if (!find) continue;
            return findPath;
        }
        return null;
    }

    private String getAgentLibPath(String agentDirPath) {
        return agentDirPath + File.separator + "lib";
    }

    private String getAgentPluginPath(String agentDirPath) {
        return agentDirPath + File.separator + "plugin";
    }

    private List<URL> resolveLib(String agentLibPath, BootDir bootDir) {
        URL agentDirUri;
        File libDir = new File(agentLibPath);
        if (this.checkDirectory(libDir)) {
            return Collections.emptyList();
        }
        ArrayList<URL> jarURLList = new ArrayList<URL>();
        File[] findJarList = this.findJar(libDir);
        if (findJarList != null) {
            for (File file : findJarList) {
                URL url = this.toURI(file);
                if (url == null) continue;
                jarURLList.add(url);
            }
        }
        if ((agentDirUri = this.toURI(new File(agentLibPath))) != null) {
            jarURLList.add(agentDirUri);
        }
        return jarURLList;
    }

    private List<String> resolvePlugins(String agentPluginPath) {
        File directory = new File(agentPluginPath);
        if (this.checkDirectory(directory)) {
            this.logger.warn(directory + " is not a directory");
            return Collections.emptyList();
        }
        File[] jars = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (this.isEmpty(jars)) {
            return Collections.emptyList();
        }
        List<String> pluginFileList = this.filterReadPermission(jars);
        for (String pluginJar : pluginFileList) {
            this.logger.info("Found plugins:" + pluginJar);
        }
        return pluginFileList;
    }

    private boolean checkDirectory(File file) {
        if (!file.exists()) {
            this.logger.warn(file + " not found");
            return true;
        }
        if (!file.isDirectory()) {
            this.logger.warn(file + " is not a directory");
            return true;
        }
        return false;
    }

    private List<String> filterReadPermission(File[] jars) {
        ArrayList<String> result = new ArrayList<String>();
        for (File pluginJar : jars) {
            if (!pluginJar.canRead()) {
                this.logger.info("File '" + pluginJar + "' cannot be read");
                continue;
            }
            result.add(pluginJar.getPath());
        }
        return result;
    }

    private URL toURI(File file) {
        URI uri = file.toURI();
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            this.logger.warn(file.getName() + ".toURL() failed.", e);
            return null;
        }
    }

    private File[] findJar(File libDir) {
        return libDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String path = pathname.getName();
                for (String extension : AgentDirBaseClassPathResolver.this.fileExtensionList) {
                    if (path.lastIndexOf("." + extension) == -1) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private String parseAgentDirPath(String agentJarFullPath) {
        int index2;
        int index1 = agentJarFullPath.lastIndexOf("/");
        int max = Math.max(index1, index2 = agentJarFullPath.lastIndexOf("\\"));
        if (max == -1) {
            return null;
        }
        return agentJarFullPath.substring(0, max);
    }
}

