/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.List;

public class DefaultAgentOption
implements AgentOption {
    private final Instrumentation instrumentation;
    private final String agentId;
    private final String applicationName;
    private final boolean isContainer;
    private final ProfilerConfig profilerConfig;
    private final List<String> pluginJars;
    private final List<String> bootstrapJarPaths;

    public DefaultAgentOption(Instrumentation instrumentation, String agentId, String applicationName, boolean isContainer, ProfilerConfig profilerConfig, List<String> pluginJars, List<String> bootstrapJarPaths) {
        if (instrumentation == null) {
            throw new NullPointerException("instrumentation must not be null");
        }
        if (agentId == null) {
            throw new NullPointerException("agentId must not be null");
        }
        if (applicationName == null) {
            throw new NullPointerException("applicationName must not be null");
        }
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        if (pluginJars == null) {
            throw new NullPointerException("pluginJars must not be null");
        }
        this.instrumentation = instrumentation;
        this.agentId = agentId;
        this.applicationName = applicationName;
        this.isContainer = isContainer;
        this.profilerConfig = profilerConfig;
        this.pluginJars = pluginJars;
        this.bootstrapJarPaths = bootstrapJarPaths == null ? Collections.emptyList() : bootstrapJarPaths;
    }

    @Override
    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    @Override
    public String getAgentId() {
        return this.agentId;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public boolean isContainer() {
        return this.isContainer;
    }

    @Override
    public List<String> getPluginJars() {
        return this.pluginJars;
    }

    @Override
    public List<String> getBootstrapJarPaths() {
        return this.bootstrapJarPaths;
    }

    @Override
    public ProfilerConfig getProfilerConfig() {
        return this.profilerConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultAgentOption{");
        sb.append("instrumentation=").append(this.instrumentation);
        sb.append(", agentId='").append(this.agentId).append('\'');
        sb.append(", applicationName='").append(this.applicationName).append('\'');
        sb.append(", isContainer=").append(this.isContainer);
        sb.append(", profilerConfig=").append(this.profilerConfig);
        sb.append(", pluginJars=").append(this.pluginJars);
        sb.append(", bootstrapJarPaths=").append(this.bootstrapJarPaths);
        sb.append('}');
        return sb.toString();
    }
}

