/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.grpc;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.plugin.grpc.GrpcConfig;
import java.security.ProtectionDomain;
import java.util.List;

class GrpcServerPlugin {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TransformTemplate transformTemplate;
    private final GrpcConfig grpcConfig;

    GrpcServerPlugin(TransformTemplate transformTemplate, GrpcConfig grpcConfig) {
        this.transformTemplate = (TransformTemplate)Assert.requireNonNull((Object)transformTemplate, (String)"transformTemplate must not be null");
        this.grpcConfig = (GrpcConfig)Assert.requireNonNull((Object)grpcConfig, (String)"grpcConfig must not be null");
    }

    void addInterceptor() {
        this.transformTemplate.transform("io.grpc.internal.ServerImpl$ServerTransportListenerImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod streamCreatedMethod = target.getDeclaredMethod("streamCreated", new String[]{"io.grpc.internal.ServerStream", "java.lang.String", "io.grpc.Metadata"});
                if (streamCreatedMethod != null) {
                    streamCreatedMethod.addInterceptor("com.navercorp.pinpoint.plugin.grpc.interceptor.server.ServerStreamCreatedInterceptor");
                } else if (GrpcServerPlugin.this.isDebug) {
                    GrpcServerPlugin.this.logger.debug("can't find streamCreated method");
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("io.grpc.internal.AbstractServerStream", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor");
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("io.grpc.ServerCall$Listener", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor");
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("io.grpc.internal.ServerCallImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.grpc.field.accessor.ServerStreamGetter", "stream");
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("io.grpc.stub.ServerCalls$UnaryServerCallHandler", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                GrpcServerPlugin.this.addStartCallMethodInterceptor(target);
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("io.grpc.stub.ServerCalls$UnaryServerCallHandler$UnaryServerCallListener", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                GrpcServerPlugin.this.addListenerMethod(target, true);
                return target.toBytecode();
            }
        });
        if (this.grpcConfig.isServerStreamingEnable()) {
            this.transformTemplate.transform("io.grpc.stub.ServerCalls$StreamingServerCallHandler", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                    GrpcServerPlugin.this.addStartCallMethodInterceptor(target);
                    return target.toBytecode();
                }
            });
            this.transformTemplate.transform("io.grpc.stub.ServerCalls$StreamingServerCallHandler$StreamingServerCallListener", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                    GrpcServerPlugin.this.addListenerMethod(target, GrpcServerPlugin.this.grpcConfig.isServerStreamingOnMessageEnable());
                    return target.toBytecode();
                }
            });
        }
    }

    private void addStartCallMethodInterceptor(InstrumentClass target) throws InstrumentException {
        InstrumentMethod startCall = target.getDeclaredMethod("startCall", new String[]{"io.grpc.ServerCall", "io.grpc.Metadata"});
        if (startCall != null) {
            startCall.addInterceptor("com.navercorp.pinpoint.plugin.grpc.interceptor.server.CopyAsyncContextInterceptor");
        } else if (this.isDebug) {
            this.logger.debug("can't find startCall method");
        }
    }

    private void addListenerMethod(InstrumentClass target, boolean traceOnMessage) throws InstrumentException {
        List declaredMethods = target.getDeclaredMethods();
        for (InstrumentMethod declaredMethod : declaredMethods) {
            if (declaredMethod.getName().equals("onMessage") && !traceOnMessage) {
                if (!this.isDebug) continue;
                this.logger.debug("skip add onMessage interceptor");
                continue;
            }
            declaredMethod.addInterceptor("com.navercorp.pinpoint.plugin.grpc.interceptor.server.ServerListenerInterceptor");
        }
    }
}

