/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.grpc;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.Assert;
import java.security.ProtectionDomain;
import java.util.List;

class GrpcClientPlugin {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final TransformTemplate transformTemplate;

    GrpcClientPlugin(TransformTemplate transformTemplate) {
        this.transformTemplate = (TransformTemplate)Assert.requireNonNull((Object)transformTemplate, (String)"transformTemplate must not be null");
    }

    void addInterceptor() {
        String managedChannel = "io.grpc.internal.ManagedChannelImpl$RealChannel";
        this.transformTemplate.transform("io.grpc.internal.ManagedChannelImpl$RealChannel", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                GrpcClientPlugin.this.addNewCallMethodInterceptor(target);
                return target.toBytecode();
            }
        });
        String oobChannel = "io.grpc.internal.OobChannel";
        this.transformTemplate.transform("io.grpc.internal.OobChannel", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                GrpcClientPlugin.this.addNewCallMethodInterceptor(target);
                return target.toBytecode();
            }
        });
        String clientStreamListener = "io.grpc.internal.ClientCallImpl$ClientStreamListenerImpl";
        this.transformTemplate.transform("io.grpc.internal.ClientCallImpl$ClientStreamListenerImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod constructor = target.getConstructor(new String[]{"io.grpc.internal.ClientCallImpl", "io.grpc.ClientCall$Listener"});
                if (constructor == null) {
                    GrpcClientPlugin.this.logger.info("can't find \"io.grpc.internal.ClientCallImpl$ClientStreamListenerImpl\" constructor");
                    return target.toBytecode();
                }
                constructor.addInterceptor("com.navercorp.pinpoint.plugin.grpc.interceptor.client.ListenerConstructorInterceptor");
                MethodFilter closedMethodsFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"closed"}), MethodFilters.argAt((int)0, (String)"io.grpc.Status")});
                List closedMethods = target.getDeclaredMethods(closedMethodsFilter);
                for (InstrumentMethod closedMethod : closedMethods) {
                    closedMethod.addInterceptor("com.navercorp.pinpoint.plugin.grpc.interceptor.client.ListenerClosedInterceptor");
                }
                target.addField(AsyncContextAccessor.class.getName());
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("io.grpc.internal.ClientCallImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod startMethod = target.getDeclaredMethod("start", new String[]{"io.grpc.ClientCall$Listener", "io.grpc.Metadata"});
                if (startMethod == null) {
                    GrpcClientPlugin.this.logger.debug("can't find start method");
                    return target.toBytecode();
                }
                startMethod.addInterceptor("com.navercorp.pinpoint.plugin.grpc.interceptor.client.ClientCallStartInterceptor");
                target.addField("com.navercorp.pinpoint.plugin.grpc.field.accessor.RemoteAddressAccessor");
                target.addField("com.navercorp.pinpoint.plugin.grpc.field.accessor.MethodNameAccessor");
                return target.toBytecode();
            }
        });
    }

    private void addNewCallMethodInterceptor(InstrumentClass target) throws InstrumentException {
        InstrumentMethod newCallMethod = target.getDeclaredMethod("newCall", new String[]{"io.grpc.MethodDescriptor", "io.grpc.CallOptions"});
        if (newCallMethod != null) {
            newCallMethod.addInterceptor("com.navercorp.pinpoint.plugin.grpc.interceptor.client.ChannelNewCallInterceptor");
        } else {
            this.logger.debug("can't find newCall method");
        }
    }
}

