/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.redis.jedis;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.redis.jedis.JedisMethodNameFilter;
import com.navercorp.pinpoint.plugin.redis.jedis.JedisPluginConfig;
import java.security.ProtectionDomain;

public class JedisPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final JedisMethodNameFilter jedisMethodNameFilter = new JedisMethodNameFilter();
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        JedisPluginConfig config = new JedisPluginConfig(context.getConfig());
        if (!config.isEnable()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Disable JedisPlugin. config={}", (Object)config);
            }
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Enable JedisPlugin. config={}", (Object)config);
        }
        boolean pipeline = config.isPipeline();
        this.addJedis(config);
        this.addProtocol();
        if (pipeline) {
            this.addClient();
            this.addPipeline(config);
        }
    }

    private void addJedis(JedisPluginConfig config) {
        this.addBinaryJedisExtends(config, "redis.clients.jedis.BinaryJedis", new TransformHandler(){

            @Override
            public void handle(InstrumentClass target) throws InstrumentException {
                target.addField("com.navercorp.pinpoint.plugin.redis.jedis.EndPointAccessor");
            }
        });
        this.addBinaryJedisExtends(config, "redis.clients.jedis.Jedis", null);
    }

    private void addBinaryJedisExtends(final JedisPluginConfig config, String targetClassName, final TransformHandler handler) {
        this.transformTemplate.transform(targetClassName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                if (handler != null) {
                    handler.handle(target);
                }
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int", "boolean"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int", "boolean", "javax.net.ssl.SSLSocketFactory", "javax.net.ssl.SSLParameters", "javax.net.ssl.HostnameVerifier"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int", "int"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int", "int", "boolean"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int", "int", "boolean", "javax.net.ssl.SSLSocketFactory", "javax.net.ssl.SSLParameters", "javax.net.ssl.HostnameVerifier"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int", "int", "int"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int", "int", "int", "boolean"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int", "int", "int", "boolean", "javax.net.ssl.SSLSocketFactory", "javax.net.ssl.SSLParameters", "javax.net.ssl.HostnameVerifier"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"redis.clients.jedis.JedisShardInfo"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.net.URI"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.net.URI", "javax.net.ssl.SSLSocketFactory", "javax.net.ssl.SSLParameters", "javax.net.ssl.HostnameVerifier"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.net.URI", "int"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.net.URI", "int", "javax.net.ssl.SSLSocketFactory", "javax.net.ssl.SSLParameters", "javax.net.ssl.HostnameVerifier"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.net.URI", "int", "int"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.net.URI", "int", "int", "javax.net.ssl.SSLSocketFactory", "javax.net.ssl.SSLParameters", "javax.net.ssl.HostnameVerifier"});
                JedisPlugin.this.addJedisMethodInterceptor(target, config, "redisJedisScope");
                return target.toBytecode();
            }
        });
    }

    private void addClient() {
        this.transformTemplate.transform("redis.clients.jedis.Client", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.redis.jedis.EndPointAccessor");
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int", "boolean"});
                JedisPlugin.this.addSetEndPointInterceptor(target, new String[]{"java.lang.String", "int", "boolean", "javax.net.ssl.SSLSocketFactory", "javax.net.ssl.SSLParameters", "javax.net.ssl.HostnameVerifier"});
                return target.toBytecode();
            }
        });
    }

    private void addSetEndPointInterceptor(InstrumentClass target, String ... parameterTypes) throws InstrumentException {
        InstrumentMethod method = target.getConstructor(parameterTypes);
        if (method != null) {
            method.addInterceptor("com.navercorp.pinpoint.plugin.redis.jedis.interceptor.SetEndPointInterceptor");
        }
    }

    private void addProtocol() {
        this.transformTemplate.transform("redis.clients.jedis.Protocol", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"sendCommand", "read"}), MethodFilters.modifierNot((int)2)}))) {
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.redis.jedis.interceptor.ProtocolSendCommandAndReadMethodInterceptor", "redisJedisScope", ExecutionPolicy.INTERNAL);
                }
                return target.toBytecode();
            }
        });
    }

    private void addPipeline(JedisPluginConfig config) {
        this.addPipelineBaseExtends(config, "redis.clients.jedis.PipelineBase", null);
        this.addPipelineBaseExtends(config, "redis.clients.jedis.MultiKeyPipelineBase", null);
        this.addPipelineBaseExtends(config, "redis.clients.jedis.Pipeline", new TransformHandler(){

            @Override
            public void handle(InstrumentClass target) throws InstrumentException {
                InstrumentMethod constructor;
                target.addField("com.navercorp.pinpoint.plugin.redis.jedis.EndPointAccessor");
                InstrumentMethod setClientMethod = target.getDeclaredMethod("setClient", new String[]{"redis.clients.jedis.Client"});
                if (setClientMethod != null) {
                    setClientMethod.addInterceptor("com.navercorp.pinpoint.plugin.redis.jedis.interceptor.AttachEndPointInterceptor");
                }
                if ((constructor = target.getConstructor(new String[]{"redis.clients.jedis.Client"})) != null) {
                    constructor.addInterceptor("com.navercorp.pinpoint.plugin.redis.jedis.interceptor.AttachEndPointInterceptor");
                }
            }
        });
    }

    private void addPipelineBaseExtends(final JedisPluginConfig config, String targetClassName, final TransformHandler handler) {
        this.transformTemplate.transform(targetClassName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                if (handler != null) {
                    handler.handle(target);
                }
                JedisPlugin.this.addJedisMethodInterceptor(target, config, "redisJedisScope");
                return target.toBytecode();
            }
        });
    }

    private void addJedisMethodInterceptor(InstrumentClass target, JedisPluginConfig config, String scope) {
        for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.chain((MethodFilter[])new MethodFilter[]{this.jedisMethodNameFilter, MethodFilters.modifierNot((int)4096)}))) {
            try {
                method.addScopedInterceptor("com.navercorp.pinpoint.plugin.redis.jedis.interceptor.JedisMethodInterceptor", VarArgs.va((Object[])new Object[]{config.isIo()}), scope);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("Unsupported method {}", (Object)method, (Object)e);
            }
        }
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    private static interface TransformHandler {
        public void handle(InstrumentClass var1) throws InstrumentException;
    }
}

