/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.redis.jedis;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JedisMethodNameFilter
implements MethodFilter {
    private final Set<String> excludeMethodNames = new HashSet<String>(16);

    public JedisMethodNameFilter() {
        this.excludeMethodNames.addAll(Arrays.asList("clone", "equals", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait"));
        this.excludeMethodNames.addAll(Arrays.asList("ping", "close", "disconnect", "resetState", "getClient", "setClient", "getDB", "isInMulti", "isInWatch", "clear", "pipelined", "setPassword", "setDb", "setDataSource", "getClusterNodes", "getConnectionFromSlot"));
    }

    public boolean accept(InstrumentMethod method) {
        if (method != null) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isNative(modifiers)) {
                return false;
            }
            String name = method.getName();
            if (!name.startsWith("_$PINPOINT$_") && !this.excludeMethodNames.contains(name)) {
                return true;
            }
        }
        return false;
    }
}

