/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jsp.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.jsp.JspConstants;

public class HttpJspBaseServiceMethodInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    private static final String JSP_PREFIX = "org.apache.jsp.";
    private static final int JSP_PREFIX_LENGTH = "org.apache.jsp.".length();
    private static final String WEB_INF = "WEB-INF";
    private static final String WEB_INF_ENCODE = "WEB_002dINF";
    private static final String JSP = ".jsp";
    private static final String JSP_ENCODE = "_jsp";

    public HttpJspBaseServiceMethodInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        super(traceContext, descriptor);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        String jspPath;
        if (target != null && (jspPath = this.parseJspName(target.getClass().getName())) != null && !jspPath.isEmpty()) {
            recorder.recordAttribute(AnnotationKey.HTTP_INTERNAL_DISPLAY, jspPath);
        }
    }

    String parseJspName(String className) {
        if (className == null || className.isEmpty()) {
            return className;
        }
        String path = this.parsePath(className);
        path = this.decode(path, WEB_INF_ENCODE, WEB_INF, false);
        path = this.decode(path, JSP_ENCODE, JSP, true);
        return path;
    }

    private String parsePath(String text) {
        if (text.startsWith(JSP_PREFIX)) {
            return text.substring(JSP_PREFIX_LENGTH).replace('.', '/');
        }
        int lastPeriodIndex = text.lastIndexOf(46);
        if (lastPeriodIndex != -1 && text.length() > lastPeriodIndex) {
            return text.substring(lastPeriodIndex + 1);
        }
        return text;
    }

    private String decode(String text, String search, String replacement, boolean lastIndex) {
        int beginIndex = lastIndex ? text.lastIndexOf(search) : text.indexOf(search);
        if (beginIndex == -1) {
            return text;
        }
        int endIndex = beginIndex + search.length();
        return this.replace(text, beginIndex, endIndex, replacement);
    }

    private String replace(String text, int beginIndex, int endIndex, String replacement) {
        StringBuilder sb = new StringBuilder();
        if (beginIndex > 0) {
            sb.append(text.substring(0, beginIndex));
        }
        sb.append(replacement);
        if (text.length() > endIndex) {
            sb.append(text.substring(endIndex));
        }
        return sb.toString();
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordException(throwable);
        recorder.recordServiceType(JspConstants.SERVICE_TYPE);
        recorder.recordApi(this.getMethodDescriptor());
    }
}

