/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient3.interceptor;

import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapper;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapperAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultRequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorderFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityRecorderFactory;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.IntBooleanIntBooleanValue;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3CallContext;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3CallContextFactory;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3Constants;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3CookieExtractor;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3EntityExtractor;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3PluginConfig;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3RequestWrapper;
import com.navercorp.pinpoint.plugin.httpclient3.HttpMethodClientHeaderAdaptor;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;

public class HttpMethodBaseExecuteMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final InterceptorScope interceptorScope;
    private final ClientRequestRecorder<ClientRequestWrapper> clientRequestRecorder;
    private final RequestTraceWriter<HttpMethod> requestTraceWriter;
    private final boolean io;
    private final CookieRecorder<HttpMethod> cookieRecorder;
    private final EntityRecorder<HttpMethod> entityRecorder;

    public HttpMethodBaseExecuteMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        if (traceContext == null) {
            throw new NullPointerException("traceContext must not be null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor must not be null");
        }
        if (interceptorScope == null) {
            throw new NullPointerException("interceptorScope must not be null");
        }
        this.traceContext = traceContext;
        this.descriptor = methodDescriptor;
        this.interceptorScope = interceptorScope;
        HttpClient3PluginConfig config = new HttpClient3PluginConfig(traceContext.getProfilerConfig());
        boolean param = config.isParam();
        HttpDumpConfig httpDumpConfig = config.getHttpDumpConfig();
        ClientRequestAdaptor clientRequestAdaptor = ClientRequestWrapperAdaptor.INSTANCE;
        this.clientRequestRecorder = new ClientRequestRecorder(param, clientRequestAdaptor);
        CookieExtractor<HttpMethod> cookieExtractor = HttpClient3CookieExtractor.INSTANCE;
        this.cookieRecorder = CookieRecorderFactory.newCookieRecorder((HttpDumpConfig)httpDumpConfig, cookieExtractor);
        EntityExtractor<HttpMethod> entityExtractor = HttpClient3EntityExtractor.INSTANCE;
        this.entityRecorder = EntityRecorderFactory.newEntityRecorder((HttpDumpConfig)httpDumpConfig, entityExtractor);
        HttpMethodClientHeaderAdaptor clientHeaderAdaptor = new HttpMethodClientHeaderAdaptor();
        this.requestTraceWriter = new DefaultRequestTraceWriter((ClientHeaderAdaptor)clientHeaderAdaptor, traceContext);
        this.io = config.isIo();
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (!trace.canSampled()) {
            if (target instanceof HttpMethod) {
                HttpMethod httpMethod = (HttpMethod)target;
                this.requestTraceWriter.write((Object)httpMethod);
            }
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        TraceId nextId = trace.getTraceId().getNextTraceId();
        recorder.recordNextSpanId(nextId.getSpanId());
        recorder.recordServiceType(HttpClient3Constants.HTTP_CLIENT_3);
        if (target instanceof HttpMethod) {
            HttpMethod httpMethod = (HttpMethod)target;
            HttpConnection httpConnection = this.getHttpConnection(args);
            String host = this.getHost(httpMethod, httpConnection);
            this.requestTraceWriter.write((Object)httpMethod, nextId, host);
        }
        this.initAttachment();
    }

    private String getHost(HttpMethod httpMethod, HttpConnection httpConnection) {
        block4: {
            try {
                URI uri = httpMethod.getURI();
                if (uri.isAbsoluteURI()) {
                    return HttpClient3RequestWrapper.getEndpoint(uri.getHost(), uri.getPort());
                }
                if (httpConnection != null) {
                    String host = httpConnection.getHost();
                    int port = HttpClient3RequestWrapper.getPort(httpConnection);
                    return HttpClient3RequestWrapper.getEndpoint(host, port);
                }
            }
            catch (Exception e) {
                if (!this.isDebug) break block4;
                this.logger.debug("Failed to get host. httpMethod={}", (Object)httpMethod, (Object)e);
            }
        }
        return null;
    }

    private HttpConnection getHttpConnection(Object[] args) {
        if (args != null && args.length > 1 && args[1] instanceof HttpConnection) {
            return (HttpConnection)args[1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            HttpClient3CallContext callContext;
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
            if (target instanceof HttpMethod) {
                HttpMethod httpMethod = (HttpMethod)target;
                HttpConnection httpConnection = this.getHttpConnection(args);
                HttpClient3RequestWrapper requestWrapper = new HttpClient3RequestWrapper(httpMethod, httpConnection);
                this.clientRequestRecorder.record(recorder, (Object)requestWrapper, throwable);
                this.cookieRecorder.record(recorder, (Object)httpMethod, throwable);
                this.entityRecorder.record(recorder, (Object)httpMethod, throwable);
            }
            if (result != null) {
                recorder.recordAttribute(AnnotationKey.HTTP_STATUS_CODE, result);
            }
            if ((callContext = this.getAndCleanAttachment()) != null) {
                this.recordIo(recorder, callContext);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private void initAttachment() {
        InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
        if (invocation != null) {
            invocation.getOrCreateAttachment(HttpClient3CallContextFactory.HTTPCLIENT3_CONTEXT_FACTORY);
        }
    }

    private HttpClient3CallContext getAndCleanAttachment() {
        InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
        Object attachment = this.getAttachment(invocation);
        if (attachment instanceof HttpClient3CallContext) {
            return (HttpClient3CallContext)invocation.removeAttachment();
        }
        return null;
    }

    private Object getAttachment(InterceptorScopeInvocation invocation) {
        if (invocation == null) {
            return null;
        }
        return invocation.getAttachment();
    }

    private void recordIo(SpanEventRecorder recorder, HttpClient3CallContext callContext) {
        if (this.io) {
            IntBooleanIntBooleanValue value = new IntBooleanIntBooleanValue((int)callContext.getWriteElapsedTime(), callContext.isWriteFail(), (int)callContext.getReadElapsedTime(), callContext.isReadFail());
            recorder.recordAttribute(AnnotationKey.HTTP_IO, (Object)value);
        }
    }
}

