/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.buffer;

import com.navercorp.pinpoint.common.buffer.FixedBuffer;
import com.navercorp.pinpoint.common.util.BytesUtils;

public class AutomaticBuffer
extends FixedBuffer {
    public AutomaticBuffer() {
        super(32);
    }

    public AutomaticBuffer(int size) {
        super(size);
    }

    public AutomaticBuffer(byte[] buffer) {
        super(buffer);
    }

    protected void checkExpand(int size) {
        int remain = this.remaining();
        if (remain >= size) {
            return;
        }
        int length = this.buffer.length;
        if (length == 0) {
            length = 1;
        }
        int expandedBufferSize = this.computeExpandedBufferSize(size, length, remain);
        byte[] expandedBuffer = new byte[expandedBufferSize];
        System.arraycopy(this.buffer, 0, expandedBuffer, 0, this.buffer.length);
        this.buffer = expandedBuffer;
    }

    protected int computeExpandedBufferSize(int size, int length, int remain) {
        int expandedBufferSize = 0;
        while (remain < size) {
            expandedBufferSize = length <<= 1;
            remain = expandedBufferSize - this.offset;
        }
        return expandedBufferSize;
    }

    @Override
    public void putPadBytes(byte[] bytes, int totalLength) {
        this.checkExpand(totalLength);
        super.putPadBytes(bytes, totalLength);
    }

    @Override
    public void putPrefixedBytes(byte[] bytes) {
        if (bytes == null) {
            this.checkExpand(1);
            super.putSVInt(-1);
        } else {
            this.checkExpand(bytes.length + 5);
            super.putSVInt(bytes.length);
            super.putBytes(bytes);
        }
    }

    @Override
    public void put2PrefixedBytes(byte[] bytes) {
        if (bytes == null) {
            this.checkExpand(2);
            super.putShort((short)-1);
        } else {
            if (bytes.length > Short.MAX_VALUE) {
                throw new IndexOutOfBoundsException("too large bytes length:" + bytes.length);
            }
            this.checkExpand(bytes.length + 2);
            super.putShort((short)bytes.length);
            super.putBytes(bytes);
        }
    }

    @Override
    public void put4PrefixedBytes(byte[] bytes) {
        if (bytes == null) {
            this.checkExpand(4);
            super.putInt(-1);
        } else {
            this.checkExpand(bytes.length + 4);
            super.putInt(bytes.length);
            super.putBytes(bytes);
        }
    }

    @Override
    public void putPadString(String string, int totalLength) {
        this.checkExpand(totalLength);
        super.putPadString(string, totalLength);
    }

    @Override
    public void putPrefixedString(String string) {
        byte[] bytes = BytesUtils.toBytes(string);
        this.putPrefixedBytes(bytes);
    }

    @Override
    public void put2PrefixedString(String string) {
        byte[] bytes = BytesUtils.toBytes(string);
        this.put2PrefixedBytes(bytes);
    }

    @Override
    public void put4PrefixedString(String string) {
        byte[] bytes = BytesUtils.toBytes(string);
        this.put4PrefixedBytes(bytes);
    }

    @Override
    public void putByte(byte v) {
        this.checkExpand(1);
        super.putByte(v);
    }

    @Override
    public void putBoolean(boolean v) {
        this.checkExpand(1);
        super.putBoolean(v);
    }

    @Override
    public void putShort(short v) {
        this.checkExpand(2);
        super.putShort(v);
    }

    @Override
    public void putInt(int v) {
        this.checkExpand(4);
        super.putInt(v);
    }

    @Override
    public void putVInt(int v) {
        this.checkExpand(10);
        super.putVInt(v);
    }

    @Override
    public void putSVInt(int v) {
        this.checkExpand(5);
        super.putSVInt(v);
    }

    @Override
    public void putVLong(long v) {
        this.checkExpand(10);
        super.putVLong(v);
    }

    @Override
    public void putSVLong(long v) {
        this.checkExpand(10);
        super.putSVLong(v);
    }

    @Override
    public void putLong(long v) {
        this.checkExpand(8);
        super.putLong(v);
    }

    @Override
    public void putBytes(byte[] v) {
        if (v == null) {
            throw new NullPointerException("v must not be null");
        }
        this.checkExpand(v.length);
        super.putBytes(v);
    }
}

