/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.commons.dbcp2;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.plugin.commons.dbcp2.CommonsDbcp2Config;
import java.security.ProtectionDomain;

public class CommonsDbcp2Plugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private CommonsDbcp2Config config;
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        this.config = new CommonsDbcp2Config(context.getConfig());
        if (!this.config.isPluginEnable()) {
            this.logger.info("Disable commons dbcp option. 'profiler.jdbc.dbcp2=false'");
            return;
        }
        this.addBasicDataSourceTransformer();
        if (this.config.isProfileClose()) {
            this.addPoolGuardConnectionWrapperTransformer();
        }
    }

    private void addPoolGuardConnectionWrapperTransformer() {
        this.transformTemplate.transform("org.apache.commons.dbcp2.PoolingDataSource$PoolGuardConnectionWrapper", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod closeMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
                closeMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.commons.dbcp2.interceptor.DataSourceCloseConnectionInterceptor", "DBCP2_SCOPE");
                return target.toBytecode();
            }
        });
    }

    private void addBasicDataSourceTransformer() {
        this.transformTemplate.transform("org.apache.commons.dbcp2.BasicDataSource", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (CommonsDbcp2Plugin.this.isAvailableDataSourceMonitor(target)) {
                    target.addField("com.navercorp.pinpoint.plugin.commons.dbcp2.DataSourceMonitorAccessor");
                    InstrumentMethod closeMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
                    closeMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.commons.dbcp2.interceptor.DataSourceCloseInterceptor", "DBCP2_SCOPE");
                    InstrumentMethod defaultConstructor = InstrumentUtils.findConstructor((InstrumentClass)target, (String[])new String[0]);
                    defaultConstructor.addScopedInterceptor("com.navercorp.pinpoint.plugin.commons.dbcp2.interceptor.DataSourceConstructorInterceptor", "DBCP2_SCOPE");
                }
                InstrumentMethod getConnectionMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getConnection", (String[])new String[0]);
                getConnectionMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.commons.dbcp2.interceptor.DataSourceGetConnectionInterceptor", "DBCP2_SCOPE");
                getConnectionMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getConnection", (String[])new String[]{"java.lang.String", "java.lang.String"});
                getConnectionMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.commons.dbcp2.interceptor.DataSourceGetConnectionInterceptor", "DBCP2_SCOPE");
                return target.toBytecode();
            }
        });
    }

    private boolean isAvailableDataSourceMonitor(InstrumentClass target) {
        boolean hasMethod = target.hasMethod("getUrl", new String[0]);
        if (!hasMethod) {
            return false;
        }
        hasMethod = target.hasMethod("getNumActive", new String[0]);
        if (!hasMethod) {
            return false;
        }
        hasMethod = target.hasMethod("getMaxTotal", new String[0]);
        return hasMethod;
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

