/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.netty;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapper;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.plugin.netty.NettyUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;

public class NettyClientRequestWrapper
implements ClientRequestWrapper {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final HttpMessage httpMessage;
    private final ChannelHandlerContext channelHandlerContext;

    public NettyClientRequestWrapper(HttpMessage httpMessage, ChannelHandlerContext channelHandlerContext) {
        this.httpMessage = (HttpMessage)Assert.requireNonNull((Object)httpMessage, (String)"httpMessage must not be null");
        this.channelHandlerContext = channelHandlerContext;
    }

    public String getDestinationId() {
        Channel channel;
        if (this.channelHandlerContext != null && (channel = this.channelHandlerContext.channel()) != null) {
            return NettyUtils.getEndPoint(channel.remoteAddress());
        }
        return "Unknown";
    }

    public String getUrl() {
        if (this.httpMessage instanceof HttpRequest) {
            return ((HttpRequest)this.httpMessage).getUri();
        }
        return null;
    }
}

