/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.boot;

import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.resolver.ConditionProvider;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.plugin.spring.boot.SpringBootConstants;
import java.util.Arrays;
import java.util.List;

public class SpringBootDetector
implements ApplicationTypeDetector {
    private static final String[] DEFAULT_SPRING_BOOT_BOOSTRAP_MAINS = new String[]{"org.springframework.boot.loader.JarLauncher", "org.springframework.boot.loader.WarLauncher", "org.springframework.boot.loader.PropertiesLauncher"};
    private final List<String> bootstrapMains;

    public SpringBootDetector(List<String> bootstrapMains) {
        this.bootstrapMains = CollectionUtils.isEmpty(bootstrapMains) ? Arrays.asList(DEFAULT_SPRING_BOOT_BOOSTRAP_MAINS) : bootstrapMains;
    }

    public ServiceType getApplicationType() {
        return SpringBootConstants.SERVICE_TYPE;
    }

    public boolean detect(ConditionProvider provider) {
        return provider.checkMainClass(this.bootstrapMains);
    }
}

