/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.cpu.ibm;

import com.ibm.lang.management.OperatingSystemMXBean;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuUsageProvider;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.JvmCpuUsageCalculator;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Java6CpuLoadMetric
implements CpuLoadMetric {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CpuUsageProvider jvmCpuUsageProvider;

    public Java6CpuLoadMetric() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean == null) {
            throw new IllegalStateException("OperatingSystemMXBean not available");
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        if (runtimeMXBean == null) {
            throw new IllegalStateException("RuntimeMXBean not available");
        }
        JvmCpuUsageProvider jvmCpuUsageProvider = new JvmCpuUsageProvider(operatingSystemMXBean, runtimeMXBean);
        try {
            jvmCpuUsageProvider.getCpuUsage();
        }
        catch (NoSuchMethodError e) {
            this.logger.warn("Expected method not found for retrieving jvm cpu usage. Cause : {}", (Object)e.getMessage());
            jvmCpuUsageProvider = CpuUsageProvider.UNSUPPORTED;
        }
        this.jvmCpuUsageProvider = jvmCpuUsageProvider;
    }

    public CpuLoadMetricSnapshot getSnapshot() {
        double jvmCpuUsage = this.jvmCpuUsageProvider.getCpuUsage();
        return new CpuLoadMetricSnapshot(jvmCpuUsage, -1.0);
    }

    public String toString() {
        return "CpuLoadMetric for IBM Java 1.6";
    }

    private static class JvmCpuUsageProvider
    implements CpuUsageProvider {
        private final JvmCpuUsageCalculator jvmCpuUsageCalculator = new JvmCpuUsageCalculator();
        private final OperatingSystemMXBean operatingSystemMXBean;
        private final RuntimeMXBean runtimeMXBean;

        private JvmCpuUsageProvider(OperatingSystemMXBean operatingSystemMXBean, RuntimeMXBean runtimeMXBean) {
            this.operatingSystemMXBean = operatingSystemMXBean;
            this.runtimeMXBean = runtimeMXBean;
        }

        public double getCpuUsage() {
            long cpuTimeNS = this.operatingSystemMXBean.getProcessCpuTimeByNS();
            long upTimeMS = this.runtimeMXBean.getUptime();
            return this.jvmCpuUsageCalculator.getJvmCpuUsage(cpuTimeNS, upTimeMS);
        }
    }
}

