/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.openwhisk.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.plugin.openwhisk.OpenwhiskConstants;
import com.navercorp.pinpoint.plugin.openwhisk.descriptor.DefaultMethodDescriptor;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.Map;

public class NoopTracerSetTraceContextInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    private static final DefaultMethodDescriptor METHOD_DESCRIPTOR = new DefaultMethodDescriptor("Openwhisk Entry Point");
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;

    public NoopTracerSetTraceContextInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        traceContext.cacheApi((MethodDescriptor)METHOD_DESCRIPTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before(Object target, Object[] args) {
        AsyncContext currentContext;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((currentContext = ((AsyncContextAccessor)args[0])._$PINPOINT$_getAsyncContext()) != null) {
            return;
        }
        if (((Option)args[1]).isEmpty()) {
            return;
        }
        Trace trace = this.populateTraceId((Option)args[1]);
        if (trace == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.traceBlockBegin();
            recorder.recordServiceType(OpenwhiskConstants.OPENWHISK_INTERNAL);
            recorder.recordApi((MethodDescriptor)METHOD_DESCRIPTOR);
            AsyncContext asyncContext = recorder.recordNextAsyncContext();
            ((AsyncContextAccessor)args[0])._$PINPOINT$_setAsyncContext(asyncContext);
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER. Caused:{}", (Object)t.getMessage(), (Object)t);
            }
        }
        finally {
            trace.traceBlockEnd();
            this.deleteTrace(trace);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
    }

    private Trace populateTraceId(Option context) {
        Map traceContextMap = (Map)context.get();
        java.util.Map map = JavaConversions.mapAsJavaMap((Map)traceContextMap);
        String transactionId = (String)map.get("transactionId");
        String spanId = (String)map.get("spanId");
        String parentSpanId = (String)map.get("parentSpanId");
        String flag = (String)map.get("flag");
        String applicationName = (String)map.get("applicationName");
        String serverTypeCode = (String)map.get("serverTypeCode");
        String entityPath = (String)map.get("entityPath");
        String endPoint = (String)map.get("endPoint");
        TraceId traceId = this.traceContext.createTraceId(transactionId, NumberUtils.parseLong((String)parentSpanId, (long)-1L), NumberUtils.parseLong((String)spanId, (long)-1L), NumberUtils.parseShort((String)flag, (short)0));
        if (traceId != null) {
            Trace trace = this.traceContext.continueAsyncTraceObject(traceId);
            SpanRecorder recorder = trace.getSpanRecorder();
            recorder.recordServiceType(OpenwhiskConstants.OPENWHISK_INVOKER);
            recorder.recordApi(this.descriptor);
            recorder.recordAcceptorHost(endPoint);
            recorder.recordRpcName(entityPath);
            recorder.recordParentApplication(applicationName, Short.valueOf(serverTypeCode).shortValue());
            return trace;
        }
        return null;
    }

    private void deleteTrace(Trace trace) {
        this.traceContext.removeTraceObject();
        trace.close();
    }
}

