/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.mongo.interceptor;

import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.MongoDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.mongo.MongoConstants;
import com.navercorp.pinpoint.plugin.mongo.MongoUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MongoDriverConnectInterceptor3_0
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logBeforeInterceptor(target, args);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        boolean success;
        if (this.isDebug) {
            this.logAfterInterceptor(target, args, result, throwable);
        }
        if (success = InterceptorUtils.isSuccess((Throwable)throwable)) {
            String writeConcern;
            String readPreference;
            if (args == null) {
                return;
            }
            List<String> hostList = this.getHostList(args[0]);
            DatabaseInfo databaseInfo = this.createDatabaseInfo(hostList, readPreference = this.getReadPreference(args[1]), writeConcern = this.getWriteConcern(args[1]));
            if (databaseInfo == null) {
                databaseInfo = UnKnownDatabaseInfo.MONGO_INSTANCE;
            }
            if (target instanceof DatabaseInfoAccessor) {
                ((DatabaseInfoAccessor)target)._$PINPOINT$_setDatabaseInfo(databaseInfo);
            }
        }
    }

    private void logBeforeInterceptor(Object target, Object[] args) {
        this.logger.beforeInterceptor(target, args);
    }

    private void logAfterInterceptor(Object target, Object[] args, Object result, Throwable throwable) {
        this.logger.afterInterceptor(target, args, result, throwable);
    }

    private DatabaseInfo createDatabaseInfo(List<String> hostList, String readPreference, String writeConcern) {
        MongoDatabaseInfo databaseInfo = new MongoDatabaseInfo(MongoConstants.MONGODB, MongoConstants.MONGO_EXECUTE_QUERY, null, null, hostList, null, null, readPreference, writeConcern);
        if (this.isDebug) {
            this.logger.debug("parse DatabaseInfo:{}", (Object)databaseInfo);
        }
        return databaseInfo;
    }

    private List<String> getHostList(Object arg) {
        Collection serverDescriptions;
        if (!(arg instanceof Cluster)) {
            return Collections.emptyList();
        }
        Cluster cluster = (Cluster)arg;
        ArrayList<String> hostList = new ArrayList<String>();
        try {
            ClusterDescription.class.getDeclaredMethod("getServerDescriptions", new Class[0]);
            serverDescriptions = cluster.getDescription().getServerDescriptions();
        }
        catch (NoSuchMethodException e) {
            serverDescriptions = cluster.getDescription().getAll();
        }
        for (ServerDescription serverDescription : serverDescriptions) {
            ServerAddress serverAddress = serverDescription.getAddress();
            String hostAddress = HostAndPort.toHostAndPortString((String)serverAddress.getHost(), (int)serverAddress.getPort());
            hostList.add(hostAddress);
        }
        return hostList;
    }

    private String getReadPreference(Object arg) {
        if (!(arg instanceof MongoClientOptions)) {
            return null;
        }
        MongoClientOptions mongoClientOptions = (MongoClientOptions)arg;
        return mongoClientOptions.getReadPreference().getName();
    }

    private String getWriteConcern(Object arg) {
        if (!(arg instanceof MongoClientOptions)) {
            return null;
        }
        MongoClientOptions mongoClientOptions = (MongoClientOptions)arg;
        return MongoUtil.getWriteConcern0(mongoClientOptions.getWriteConcern());
    }
}

