/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.mongo.interceptor;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.MongoDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;
import com.navercorp.pinpoint.plugin.mongo.MongoUtil;
import com.navercorp.pinpoint.plugin.mongo.NormalizedBson;
import com.navercorp.pinpoint.plugin.mongo.interceptor.DatabaseInfoUtils;

public class MongoCUDSessionInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    private final PLogger logger = PLoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final boolean collectJson;
    private final boolean traceBsonBindValue;

    public MongoCUDSessionInterceptor(TraceContext traceContext, MethodDescriptor descriptor, boolean collectJson, boolean traceBsonBindValue) {
        super(traceContext, descriptor);
        this.collectJson = collectJson;
        this.traceBsonBindValue = traceBsonBindValue;
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        DatabaseInfo databaseInfo = DatabaseInfoUtils.getDatabaseInfo(target, UnKnownDatabaseInfo.MONGO_INSTANCE);
        recorder.recordServiceType(databaseInfo.getExecuteQueryType());
        recorder.recordEndPoint(databaseInfo.getMultipleHost());
        recorder.recordDestinationId(databaseInfo.getDatabaseId());
        recorder.recordApi(this.methodDescriptor);
        MongoUtil.recordMongoCollection(recorder, ((MongoDatabaseInfo)databaseInfo).getCollectionName(), ((MongoDatabaseInfo)databaseInfo).getWriteConcern());
    }

    protected void prepareAfterTrace(Object target, Object[] args, Object result, Throwable throwable) {
    }

    public void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        boolean success;
        if (this.collectJson && (success = InterceptorUtils.isSuccess((Throwable)throwable)) && args != null) {
            NormalizedBson parsedBson = MongoUtil.parseBson(args, this.traceBsonBindValue);
            MongoUtil.recordParsedBson(recorder, parsedBson);
        }
        recorder.recordException(throwable);
    }
}

