/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.mongo;

import com.mongodb.WriteConcern;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.common.util.StringStringValue;
import com.navercorp.pinpoint.plugin.mongo.MongoConstants;
import com.navercorp.pinpoint.plugin.mongo.MongoWriteConcernMapper;
import com.navercorp.pinpoint.plugin.mongo.NormalizedBson;
import com.navercorp.pinpoint.plugin.mongo.StringJoiner;
import com.navercorp.pinpoint.plugin.mongo.WriteContext;
import java.util.ArrayList;
import org.bson.BsonType;

public final class MongoUtil {
    public static final String SEPARATOR = ",";
    private static final MongoWriteConcernMapper mongoWriteConcernMapper = new MongoWriteConcernMapper();
    private static final boolean decimal128Enabled = MongoUtil.decimal128Enabled();

    private MongoUtil() {
    }

    private static boolean decimal128Enabled() {
        for (BsonType bsonType : BsonType.values()) {
            if (!bsonType.name().equalsIgnoreCase("DECIMAL128")) continue;
            return true;
        }
        return false;
    }

    public static void recordMongoCollection(SpanEventRecorder recorder, String collectionName, String readPreferenceOrWriteConcern) {
        recorder.recordAttribute(MongoConstants.MONGO_COLLECTION_INFO, collectionName);
        recorder.recordAttribute(MongoConstants.MONGO_COLLECTION_OPTION, readPreferenceOrWriteConcern);
    }

    public static String getWriteConcern0(WriteConcern writeConcern) {
        return mongoWriteConcernMapper.getName(writeConcern);
    }

    public static void recordParsedBson(SpanEventRecorder recorder, NormalizedBson normalizedBson) {
        if (normalizedBson != null) {
            StringStringValue stringStringValue = new StringStringValue(normalizedBson.getNormalizedBson(), normalizedBson.getParameter());
            recorder.recordAttribute(MongoConstants.MONGO_JSON_DATA, (Object)stringStringValue);
        }
    }

    public static NormalizedBson parseBson(Object[] args, boolean traceBsonBindValue) {
        if (args == null) {
            return null;
        }
        ArrayList<String> parsedJson = new ArrayList<String>(2);
        ArrayList<String> jsonParameter = new ArrayList<String>(16);
        Object[] arr$ = args;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            WriteContext writeContext = new WriteContext(jsonParameter, decimal128Enabled, traceBsonBindValue);
            Object arg = arr$[i$];
            String documentString = writeContext.parse(arg);
            if (documentString.equals("Unsupported-trace")) continue;
            parsedJson.add(documentString);
        }
        String parsedJsonString = StringJoiner.join(parsedJson, SEPARATOR);
        String jsonParameterString = StringJoiner.join(jsonParameter, SEPARATOR);
        return new NormalizedBson(parsedJsonString, jsonParameterString);
    }
}

