/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.AsyncStateSupport;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.http.HttpStatusCodeRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.method.AsyncListenerOnCompleteMethodDescriptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.method.AsyncListenerOnErrorMethodDescriptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.method.AsyncListenerOnTimeoutMethodDescriptor;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.Assert;

public class AsyncListenerInterceptorHelper {
    private static final MethodDescriptor ASYNC_LISTENER_ON_COMPLETE_METHOD_DESCRIPTOR = new AsyncListenerOnCompleteMethodDescriptor();
    private static final MethodDescriptor ASYNC_LISTENER_ON_ERROR_METHOD_DESCRIPTOR = new AsyncListenerOnErrorMethodDescriptor();
    private static final MethodDescriptor ASYNC_LISTENER_ON_TIMEOUT_METHOD_DESCRIPTOR = new AsyncListenerOnTimeoutMethodDescriptor();
    private PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final AsyncContext asyncContext;
    private final HttpStatusCodeRecorder httpStatusCodeRecorder;

    public AsyncListenerInterceptorHelper(TraceContext traceContext, AsyncContext asyncContext) {
        Assert.requireNonNull((Object)traceContext, (String)"traceContext must not be null");
        this.asyncContext = (AsyncContext)Assert.requireNonNull((Object)asyncContext, (String)"asyncContext must not be null");
        this.httpStatusCodeRecorder = new HttpStatusCodeRecorder(traceContext.getProfilerConfig().getHttpStatusCodeErrors());
        traceContext.cacheApi(ASYNC_LISTENER_ON_COMPLETE_METHOD_DESCRIPTOR);
        traceContext.cacheApi(ASYNC_LISTENER_ON_ERROR_METHOD_DESCRIPTOR);
        traceContext.cacheApi(ASYNC_LISTENER_ON_TIMEOUT_METHOD_DESCRIPTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(Throwable throwable, int statusCode) {
        Trace trace;
        if (this.isDebug) {
            this.logger.debug("Complete async listener. throwable={}, statusCode={}", (Object)throwable, (Object)statusCode);
        }
        if ((trace = this.asyncContext.continueAsyncTraceObject()) == null) {
            return;
        }
        try {
            this.recordHttpStatusCode(trace, statusCode);
            this.recordAsyncEvent(trace, throwable, ASYNC_LISTENER_ON_COMPLETE_METHOD_DESCRIPTOR);
        }
        finally {
            this.close(trace);
            this.finish();
        }
    }

    private void recordHttpStatusCode(Trace trace, int statusCode) {
        SpanRecorder spanRecorder = trace.getSpanRecorder();
        this.httpStatusCodeRecorder.record(spanRecorder, statusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.debug("Error async listener. throwable={}", throwable);
        }
        if ((trace = this.asyncContext.continueAsyncTraceObject()) == null) {
            return;
        }
        try {
            this.recordAsyncEvent(trace, throwable, ASYNC_LISTENER_ON_ERROR_METHOD_DESCRIPTOR);
        }
        finally {
            this.close(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.debug("Timeout async listener. throwable={}", throwable);
        }
        if ((trace = this.asyncContext.continueAsyncTraceObject()) == null) {
            return;
        }
        try {
            this.recordAsyncEvent(trace, throwable, ASYNC_LISTENER_ON_TIMEOUT_METHOD_DESCRIPTOR);
        }
        finally {
            this.close(trace);
        }
    }

    private void recordAsyncEvent(Trace trace, Throwable throwable, MethodDescriptor methodDescriptor) {
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(ServiceType.SERVLET);
        recorder.recordApi(methodDescriptor);
        recorder.recordException(throwable);
        trace.traceBlockEnd();
    }

    private void close(Trace trace) {
        trace.close();
        this.asyncContext.close();
    }

    private void finish() {
        if (this.asyncContext instanceof AsyncStateSupport) {
            AsyncStateSupport asyncStateSupport = (AsyncStateSupport)((Object)this.asyncContext);
            AsyncState asyncState = asyncStateSupport.getAsyncState();
            asyncState.finish();
        }
    }
}

