/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher.operand;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.AbstractMatcherOperand;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.ClassUtils;

@InterfaceStability.Unstable
public class AnnotationInternalNameMatcherOperand
extends AbstractMatcherOperand {
    private final String annotationInternalName;
    private final boolean considerMetaAnnotation;

    public AnnotationInternalNameMatcherOperand(String annotationName, boolean considerMetaAnnotation) {
        Assert.requireNonNull((Object)annotationName, (String)"annotationName must not be null");
        this.annotationInternalName = ClassUtils.toInternalName((String)annotationName);
        this.considerMetaAnnotation = considerMetaAnnotation;
    }

    public String getAnnotationInternalName() {
        return this.annotationInternalName;
    }

    public boolean isConsiderMetaAnnotation() {
        return this.considerMetaAnnotation;
    }

    public boolean match(String annotationInternalName) {
        if (annotationInternalName == null) {
            return false;
        }
        return this.annotationInternalName.equals(annotationInternalName);
    }

    @Override
    public int getExecutionCost() {
        return this.considerMetaAnnotation ? 5 : 2;
    }

    @Override
    public boolean isIndex() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("annotationInternalName=").append(this.annotationInternalName);
        sb.append(", considerMetaAnnotation=").append(this.considerMetaAnnotation);
        sb.append('}');
        return sb.toString();
    }
}

