/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.util;

import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import java.lang.reflect.Field;

public final class ResinVersionUtil {
    private static final ILogger logger = LoggerFactory.getLogger(ResinVersionUtil.class.getName());
    private static Field fullVersion;
    private static Field version;

    public static boolean checkResin4Version() {
        return ResinVersionUtil.isResinVersion() && ResinVersionUtil.isResinFullVersion();
    }

    private static boolean isResinFullVersion() {
        try {
            String full = (String)fullVersion.get(null);
            return full != null && full.length() > 0 && (full.contains("4.0") || full.contains("4.1"));
        }
        catch (Exception var1) {
            return false;
        }
    }

    private static boolean isResinVersion() {
        try {
            String sub = (String)version.get(null);
            return sub != null && sub.length() > 0 && (sub.startsWith("4.0") || sub.startsWith("4.1"));
        }
        catch (Exception var1) {
            return false;
        }
    }

    static {
        Class<?> versionClass = null;
        try {
            versionClass = Class.forName("com.caucho.ProVersion");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (versionClass == null) {
                versionClass = Class.forName("com.caucho.Version");
            }
            fullVersion = versionClass.getField("FULL_VERSION");
            version = versionClass.getField("VERSION");
        }
        catch (Exception e) {
            logger.error("check resin version is failed .", e.getMessage());
        }
    }
}

