/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.logger.autolog.processor;

import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import java.io.File;
import java.io.FilenameFilter;

public class LockFileExistCheckerProcessor
implements IProcessor {
    private FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("log_lock.");
        }
    };

    @Override
    public String process(ProcessContext context) throws ProcessException {
        File processDir = (File)context.get("processDir");
        File[] files = processDir.listFiles(this.filter);
        if (files == null || files.length == 0) {
            context.put("suffixIndex", 0);
            return "next";
        }
        int maxSuffixIndex = -1;
        File currentLockFile = null;
        for (File file : files) {
            int suffixIndex = Integer.parseInt(file.getName().split("\\.")[1]);
            if (suffixIndex <= maxSuffixIndex) continue;
            maxSuffixIndex = suffixIndex;
            currentLockFile = file;
        }
        context.put("suffixIndex", ++maxSuffixIndex);
        context.put("currentLockFile", currentLockFile);
        return "checkLockTimeUpdater";
    }
}

