/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow.processors;

import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.flow.processors.UpdateResult;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;

public class MD5CheckProcessor
implements IProcessor {
    private ILogger logger = LoggerFactory.getLogger("MD5CheckProcessor");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(ProcessContext context) throws ProcessException {
        String string;
        File updateFile = (File)context.get("update_file");
        String md5 = (String)context.get("update_md5");
        FileInputStream fis = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            fis = new FileInputStream(updateFile);
            byte[] buff = new byte[10240];
            int nRead = fis.read(buff);
            while (nRead > 0) {
                messageDigest.update(buff, 0, nRead);
                nRead = fis.read(buff);
            }
            byte[] bMd5 = messageDigest.digest();
            StringBuffer sb = new StringBuffer();
            String hex = null;
            for (int i = 0; i < bMd5.length; ++i) {
                hex = Integer.toHexString(bMd5[i] & 0xFF);
                sb.append(hex.length() == 2 ? hex : "0" + hex);
            }
            String updateFileMD5 = sb.toString();
            if (updateFileMD5.equalsIgnoreCase(md5)) {
                String string2 = "next";
                return string2;
            }
            context.put("context_update_result", UpdateResult.failed(3, "Inconsistent MD5, md5: " + md5 + ", except: " + updateFileMD5));
            this.logger.info("MD5 check failed, Tapm agent MD5: {}, calculated MD5: {}", md5, updateFileMD5);
            string = "failed";
        }
        catch (Exception e) {
            context.put("context_update_result", UpdateResult.failed(4, "Errors occurred in the MD5 verification process, " + e.getMessage()));
            this.logger.error("MD5 check failed for Tapm agent", e);
            String string3 = "failed";
            return string3;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }
}

