/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow.processors;

import com.tapm.starter.AgentStarter;
import com.tapm.starter.StarterProperties;
import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import com.tapm.starter.util.StarterUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;

public class ClearFileProcessor
implements IProcessor {
    private static final ILogger logger = LoggerFactory.getLogger("ClearFileProcessor");
    private static final long UNIT_CLEAR_THRESHOLD = 1000L;
    private static final long UNIT_M = 1000000L;

    @Override
    public String process(ProcessContext context) throws ProcessException {
        StarterProperties properties = (StarterProperties)context.get("properties");
        String dataDir = (String)context.get("agentDataDir");
        String logDir = (String)context.get("agentLogDir");
        Boolean isOneAgent = (Boolean)context.get("isOneAgent");
        if (isOneAgent != null && isOneAgent.booleanValue()) {
            return "next";
        }
        long autoClearThreshold = (long)Integer.parseInt(properties.getProperty("agent_auto_clear.threshold", "600")) * 1000L;
        int dataMaxSize = Integer.parseInt(properties.getProperty("agent_data_auto_clear.max_size", "1000"));
        int dataMaxFileCount = Integer.parseInt(properties.getProperty("agent_data_auto_clear.max_file_count", "50"));
        int dataMaxDays = Integer.parseInt(properties.getProperty("agent_data_auto_clear.max_days", "1"));
        int logMaxSize = Integer.parseInt(properties.getProperty("agent_log_auto_clear.max_size", "5000"));
        int logMaxFileCount = Integer.parseInt(properties.getProperty("agent_log_auto_clear.max_file_count", "80"));
        int logMaxDays = Integer.parseInt(properties.getProperty("agent_log_auto_clear.max_days", "5"));
        this.clearDataDir(new File(dataDir), (long)dataMaxSize * 1000000L, dataMaxFileCount, dataMaxDays, autoClearThreshold, false);
        if (AgentStarter.isAutoClear) {
            this.clearDataDir(new File(logDir), (long)logMaxSize * 1000000L, logMaxFileCount, logMaxDays, autoClearThreshold, true);
        }
        return "next";
    }

    private boolean canDelete(File file) {
        return file != null && !"tapm.uuid".equals(file.getName()) && !"lock".equals(file.getName());
    }

    private void clearDataDir(File dataDir, long maxSize, int maxFileCount, int maxDay, long autoClearThreshold, boolean isLogDir) {
        File[] files;
        if (!this.canClearDataDir(dataDir, autoClearThreshold)) {
            return;
        }
        if (StarterUtil.isLinuxOs()) {
            for (File file : files = dataDir.listFiles()) {
                try {
                    boolean result;
                    String fileName = file.getName();
                    if (fileName.contains(".docker.") || isLogDir) continue;
                    int index = fileName.lastIndexOf(".");
                    int pid = Integer.parseInt(fileName.substring(index + 1));
                    File testFile = new File("/proc/" + pid + "/exe");
                    if (testFile.exists() || !(result = file.delete())) continue;
                    logger.info("The file {} is deleted, because the process was shutdown. ", fileName);
                }
                catch (Exception fileName) {
                    // empty catch block
                }
            }
        }
        if (maxDay > 0) {
            for (File file : files = dataDir.listFiles()) {
                if (System.currentTimeMillis() - file.lastModified() <= TimeUnit.DAYS.toMillis(maxDay)) continue;
                try {
                    boolean result;
                    if (!this.canDelete(file) || !(result = file.delete())) continue;
                    logger.info("The file {} was deleted, because it existed for more than {} days. ", file.getName(), maxDay);
                }
                catch (Exception result) {
                    // empty catch block
                }
            }
        }
        if (maxSize > 0L) {
            files = dataDir.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return (int)(o1.lastModified() - o2.lastModified());
                }
            });
            int i = -1;
            while (++i < 20 && this.getDirLength(dataDir) > maxSize) {
                try {
                    boolean result;
                    File deleteFile = files[i];
                    if (!this.canDelete(deleteFile) || !(result = deleteFile.delete())) continue;
                    logger.info("The file {} was deleted, because the file directory {} larger than the limit {}. ", deleteFile.getName(), dataDir, maxSize);
                }
                catch (Exception deleteFile) {}
            }
        }
        if (maxFileCount > 0) {
            files = dataDir.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return (int)(o1.lastModified() - o2.lastModified());
                }
            });
            int fileCount = files.length;
            int i = -1;
            while (fileCount-- > maxFileCount) {
                try {
                    boolean result;
                    File deleteFile;
                    if ((deleteFile = files[++i]) == null) continue;
                    String fileName = deleteFile.getName();
                    if (fileName != null && "lock".equals(fileName)) {
                        logger.info("ignore lock file");
                        continue;
                    }
                    if (!this.canDelete(deleteFile) || !(result = deleteFile.delete())) continue;
                    logger.info("The file {} was deleted, because the number of files is greater than the limit {}.", deleteFile.getName(), maxFileCount);
                }
                catch (Exception exception) {}
            }
        }
    }

    private long getDirLength(File dataDir) {
        File[] files = dataDir.listFiles();
        long length = 0L;
        for (File file : files) {
            length += file.length();
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canClearDataDir(File dataDir, long autoClearThreshold) {
        File[] files = dataDir.listFiles();
        if (files == null) return false;
        if (files.length == 0) {
            return false;
        }
        File dirLockFile = new File(dataDir, "lock");
        if (!dirLockFile.exists()) {
            try {
                if (dirLockFile.createNewFile()) {
                    dirLockFile.setWritable(true, false);
                    dirLockFile.setReadable(true, false);
                    dirLockFile.setExecutable(false, false);
                    return true;
                }
            }
            catch (IOException e) {
                logger.warn("Failed to create data lock", e);
                return false;
            }
        }
        FileOutputStream fout = null;
        try {
            if (!dirLockFile.canWrite()) {
                boolean bl = false;
                return bl;
            }
            long lastModified = dirLockFile.lastModified();
            if (System.currentTimeMillis() - lastModified < autoClearThreshold) {
                boolean bl = false;
                return bl;
            }
            fout = new FileOutputStream(dirLockFile, true);
            int i = 0;
            while (i < 5) {
                long len = dirLockFile.length();
                fout.write(new byte[]{0});
                fout.flush();
                long newLen = dirLockFile.length();
                if (len + 1L == newLen) {
                    try {
                        fout.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    fout = new FileOutputStream(dirLockFile, false);
                    fout.write(new byte[]{0});
                    fout.close();
                    fout = null;
                    boolean bl = true;
                    return bl;
                }
                lastModified = dirLockFile.lastModified();
                if (System.currentTimeMillis() - lastModified < autoClearThreshold) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
            return false;
        }
        catch (Exception e) {
            logger.error("Failed to acquire lock " + dirLockFile, e);
            return false;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

