/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow;

import com.tapm.starter.flow.FlowItem;
import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.FlowItemNotExistException;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.flow.exception.ProcessorExistedException;
import com.tapm.starter.flow.exception.ProcessorNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class FlowEngine {
    private Map<String, IProcessor> processors = new HashMap<String, IProcessor>();

    public void registProcessor(String name, IProcessor processor) throws ProcessorExistedException {
        if (this.processors.containsKey(name)) {
            throw new ProcessorExistedException(name);
        }
        this.processors.put(name, processor);
    }

    public void start(FlowItem flowItem) throws ProcessorNotFoundException, FlowItemNotExistException, ProcessException {
        this.start(flowItem, null);
    }

    public void start(FlowItem flowItem, ProcessContext processContext) throws ProcessorNotFoundException, FlowItemNotExistException, ProcessException {
        String processorName = flowItem.getProcessorName();
        IProcessor processor = this.processors.get(processorName);
        if (processor == null) {
            throw new ProcessorNotFoundException(processorName);
        }
        if (processContext == null) {
            processContext = new ProcessContext();
        }
        String flowName = processor.process(processContext);
        while (flowName != null && !flowName.equals("finished")) {
            if ((flowItem = flowItem.next(flowName)) == null) {
                throw new FlowItemNotExistException(flowName);
            }
            processorName = flowItem.getProcessorName();
            processor = this.processors.get(processorName);
            if (processor == null) {
                throw new ProcessorNotFoundException(processorName);
            }
            flowName = processor.process(processContext);
        }
    }
}

