/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.tools;

import com.navercorp.pinpoint.bootstrap.config.DefaultProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializerFactory;
import com.navercorp.pinpoint.thrift.io.NetworkAvailabilityCheckPacket;
import com.navercorp.pinpoint.tools.network.TCPChecker;
import com.navercorp.pinpoint.tools.network.UDPChecker;
import java.io.IOException;
import java.util.Arrays;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAvailabilityChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkAvailabilityChecker.class);

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage : " + NetworkAvailabilityChecker.class.getSimpleName() + " AGENT_CONFIG_FILE");
            return;
        }
        String configPath = args[0];
        ProfilerConfig profilerConfig = null;
        try {
            profilerConfig = DefaultProfilerConfig.load(configPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            NetworkAvailabilityChecker.checkUDPStat(profilerConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            NetworkAvailabilityChecker.checkUDPSpan(profilerConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            NetworkAvailabilityChecker.checkTCP(profilerConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkUDPStat(ProfilerConfig profilerConfig) throws Exception {
        String ip = profilerConfig.getCollectorStatServerIp();
        int port = profilerConfig.getCollectorStatServerPort();
        UDPChecker checker = new UDPChecker("UDP-STAT", ip, port);
        checker.check(NetworkAvailabilityChecker.getNetworkCheckPayload(), NetworkAvailabilityChecker.getNetworkCheckResponsePayload());
    }

    private static void checkUDPSpan(ProfilerConfig profilerConfig) throws Exception {
        String ip = profilerConfig.getCollectorSpanServerIp();
        int port = profilerConfig.getCollectorSpanServerPort();
        UDPChecker checker = new UDPChecker("UDP-SPAN", ip, port);
        checker.check(NetworkAvailabilityChecker.getNetworkCheckPayload(), NetworkAvailabilityChecker.getNetworkCheckResponsePayload());
    }

    private static void checkTCP(ProfilerConfig profilerConfig) throws Exception {
        String ip = profilerConfig.getCollectorTcpServerIp();
        int port = profilerConfig.getCollectorTcpServerPort();
        TCPChecker checker = new TCPChecker("TCP", ip, port);
        checker.check();
    }

    private static byte[] getNetworkCheckPayload() throws TException {
        HeaderTBaseSerializer serializer = new HeaderTBaseSerializerFactory(false, 65535, false).createSerializer();
        byte[] payload = serializer.serialize(new NetworkAvailabilityCheckPacket());
        int size = serializer.getInterBufferSize();
        return Arrays.copyOf(payload, size);
    }

    private static byte[] getNetworkCheckResponsePayload() {
        return Arrays.copyOf(NetworkAvailabilityCheckPacket.DATA_OK, NetworkAvailabilityCheckPacket.DATA_OK.length);
    }
}

