/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.buffer.AutomaticBuffer;
import com.navercorp.pinpoint.common.trace.HistogramSchema;
import com.navercorp.pinpoint.common.trace.HistogramSlot;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.BytesUtils;
import com.navercorp.pinpoint.common.util.TimeUtils;

public class ApplicationMapStatisticsUtils {
    private ApplicationMapStatisticsUtils() {
    }

    public static byte[] makeColumnName(short serviceType, String applicationName, String destHost, short slotNumber) {
        if (applicationName == null) {
            throw new NullPointerException("applicationName must not be null");
        }
        if (destHost == null) {
            destHost = "";
        }
        AutomaticBuffer buffer = new AutomaticBuffer(26 + destHost.length() + 2);
        buffer.putShort(serviceType);
        buffer.putShort(slotNumber);
        buffer.put2PrefixedString(applicationName);
        buffer.putBytes(BytesUtils.toBytes(destHost));
        return buffer.getBuffer();
    }

    public static short getSlotNumber(ServiceType serviceType, int elapsed, boolean isError) {
        return ApplicationMapStatisticsUtils.findResponseHistogramSlotNo(serviceType, elapsed, isError);
    }

    public static byte[] makeColumnName(String agentId, short columnSlotNumber) {
        if (agentId == null) {
            agentId = "";
        }
        AutomaticBuffer buffer = new AutomaticBuffer(agentId.length() + 2);
        buffer.putShort(columnSlotNumber);
        byte[] agentIdBytes = BytesUtils.toBytes(agentId);
        buffer.putBytes(agentIdBytes);
        return buffer.getBuffer();
    }

    private static short findResponseHistogramSlotNo(ServiceType serviceType, int elapsed, boolean isError) {
        if (serviceType == null) {
            throw new NullPointerException("serviceType must not be null");
        }
        HistogramSchema histogramSchema = serviceType.getHistogramSchema();
        HistogramSlot histogramSlot = histogramSchema.findHistogramSlot(elapsed, isError);
        return histogramSlot.getSlotTime();
    }

    public static short getDestServiceTypeFromColumnName(byte[] bytes) {
        return BytesUtils.bytesToShort(bytes, 0);
    }

    public static short getHistogramSlotFromColumnName(byte[] bytes) {
        return BytesUtils.bytesToShort(bytes, 2);
    }

    public static String getDestApplicationNameFromColumnName(byte[] bytes) {
        short length = BytesUtils.bytesToShort(bytes, 4);
        return BytesUtils.toStringAndRightTrim(bytes, 6, length);
    }

    public static String getDestApplicationNameFromColumnNameForUser(byte[] bytes, ServiceType destServiceType) {
        String destApplicationName = ApplicationMapStatisticsUtils.getDestApplicationNameFromColumnName(bytes);
        String destServiceTypeName = destServiceType.getName();
        return destApplicationName + "_" + destServiceTypeName;
    }

    public static String getHost(byte[] bytes) {
        int offset = 6 + BytesUtils.bytesToShort(bytes, 4);
        if (offset == bytes.length) {
            return null;
        }
        return BytesUtils.toStringAndRightTrim(bytes, offset, bytes.length - offset);
    }

    public static byte[] makeRowKey(String applicationName, short applicationType, long timestamp) {
        if (applicationName == null) {
            throw new NullPointerException("applicationName must not be null");
        }
        byte[] applicationNameBytes = BytesUtils.toBytes(applicationName);
        AutomaticBuffer buffer = new AutomaticBuffer(2 + applicationNameBytes.length + 2 + 8);
        buffer.putShort((short)applicationNameBytes.length);
        buffer.putBytes(applicationNameBytes);
        buffer.putShort(applicationType);
        long reverseTimeMillis = TimeUtils.reverseTimeMillis(timestamp);
        buffer.putLong(reverseTimeMillis);
        return buffer.getBuffer();
    }

    public static String getApplicationNameFromRowKey(byte[] bytes, int offset) {
        if (bytes == null) {
            throw new NullPointerException("bytes must not be null");
        }
        short applicationNameLength = BytesUtils.bytesToShort(bytes, offset);
        return BytesUtils.toString(bytes, offset + 2, applicationNameLength);
    }

    public static String getApplicationNameFromRowKey(byte[] bytes) {
        return ApplicationMapStatisticsUtils.getApplicationNameFromRowKey(bytes, 0);
    }

    public static short getApplicationTypeFromRowKey(byte[] bytes) {
        return ApplicationMapStatisticsUtils.getApplicationTypeFromRowKey(bytes, 0);
    }

    public static short getApplicationTypeFromRowKey(byte[] bytes, int offset) {
        if (bytes == null) {
            throw new NullPointerException("bytes must not be null");
        }
        short applicationNameLength = BytesUtils.bytesToShort(bytes, offset);
        return BytesUtils.bytesToShort(bytes, offset + applicationNameLength + 2);
    }

    public static long getTimestampFromRowKey(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes must not be null");
        }
        short applicationNameLength = BytesUtils.bytesToShort(bytes, 0);
        return TimeUtils.recoveryTimeMillis(BytesUtils.bytesToLong(bytes, applicationNameLength + 4));
    }
}

