/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.resolver;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.resolver.ConditionProvider;
import com.navercorp.pinpoint.common.trace.ServiceType;
import java.util.List;

public class ApplicationServerTypePluginResolver {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final List<ApplicationTypeDetector> applicationTypeDetectors;
    private final ConditionProvider conditionProvider;
    private static final ServiceType DEFAULT_SERVER_TYPE = ServiceType.STAND_ALONE;

    public ApplicationServerTypePluginResolver(List<ApplicationTypeDetector> serverTypeDetectors) {
        this(serverTypeDetectors, ConditionProvider.DEFAULT_CONDITION_PROVIDER);
    }

    public ApplicationServerTypePluginResolver(List<ApplicationTypeDetector> serverTypeDetectors, ConditionProvider conditionProvider) {
        if (serverTypeDetectors == null) {
            throw new IllegalArgumentException("applicationTypeDetectors should not be null");
        }
        if (conditionProvider == null) {
            throw new IllegalArgumentException("conditionProvider should not be null");
        }
        this.applicationTypeDetectors = serverTypeDetectors;
        this.conditionProvider = conditionProvider;
    }

    public ServiceType resolve() {
        for (ApplicationTypeDetector currentDetector : this.applicationTypeDetectors) {
            String currentDetectorName = currentDetector.getClass().getName();
            this.logger.info("Attempting to resolve using [{}]", (Object)currentDetectorName);
            if (currentDetector.detect(this.conditionProvider)) {
                this.logger.info("Match found using [{}]", (Object)currentDetectorName);
                return currentDetector.getApplicationType();
            }
            this.logger.info("No match found using [{}]", (Object)currentDetectorName);
        }
        this.logger.debug("Server type not resolved. Defaulting to {}", (Object)DEFAULT_SERVER_TYPE.getName());
        return DEFAULT_SERVER_TYPE;
    }
}

