/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request.util;

import com.navercorp.pinpoint.bootstrap.context.RemoteAddressResolver;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;

public class RealIpHeaderResolver<T>
implements RemoteAddressResolver<T> {
    private final String realIpHeaderName;
    private final String realIpHeaderEmptyValue;

    public RealIpHeaderResolver(String realIpHeaderName, String realIpHeaderEmptyValue) {
        this.realIpHeaderName = Assert.requireNonNull(realIpHeaderName, "realIpHeaderName must not be null");
        this.realIpHeaderEmptyValue = realIpHeaderEmptyValue;
    }

    @Override
    public String resolve(RequestAdaptor<T> requestAdaptor, T request) {
        String realIp = requestAdaptor.getHeader(request, this.realIpHeaderName);
        if (StringUtils.isEmpty(realIp)) {
            return null;
        }
        if (this.realIpHeaderEmptyValue != null && this.realIpHeaderEmptyValue.equalsIgnoreCase(realIp)) {
            return null;
        }
        int firstIndex = realIp.indexOf(44);
        if (firstIndex == -1) {
            return realIp;
        }
        return realIp.substring(0, firstIndex);
    }
}

