/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.proxy;

import com.navercorp.pinpoint.bootstrap.plugin.proxy.ProxyHttpHeader;
import com.navercorp.pinpoint.common.util.StringUtils;

public class ProxyHttpHeaderParser {
    private final ProxyTimeUnit nginxUnit = new NginxTimeUnit();
    private final ProxyTimeUnit apacheUnit = new ApacheTimeUnit();
    private final ProxyTimeUnit appUnit = new AppTimeUnit();

    public ProxyHttpHeader parse(int type, String value) {
        ProxyHttpHeader header = new ProxyHttpHeader(type);
        if (value == null) {
            header.setValid(false);
            header.setCause("value is must not be null");
            return header;
        }
        if (type == 1) {
            this.parseFormat(header, value, this.appUnit);
        } else if (type == 2) {
            this.parseFormat(header, value, this.nginxUnit);
        } else if (type == 3) {
            this.parseFormat(header, value, this.apacheUnit);
        } else {
            header.setValid(false);
            header.setCause("unknown type");
        }
        return header;
    }

    void parseFormat(ProxyHttpHeader header, String value, ProxyTimeUnit proxyTimeUnit) {
        for (String token : StringUtils.tokenizeToStringList(value, " ")) {
            String app;
            if (token.startsWith("t=")) {
                long receivedTimeMillis = proxyTimeUnit.toReceivedTimeMillis(token.substring(2));
                if (receivedTimeMillis > 0L) {
                    header.setReceivedTimeMillis(receivedTimeMillis);
                    header.setValid(true);
                    continue;
                }
                header.setValid(false);
                header.setCause("invalid received time");
                return;
            }
            if (token.startsWith("D=")) {
                long durationTimeMicroseconds = proxyTimeUnit.toDurationTimeMicros(token.substring(2));
                if (durationTimeMicroseconds <= 0L) continue;
                header.setDurationTimeMicroseconds((int)durationTimeMicroseconds);
                continue;
            }
            if (token.startsWith("i=")) {
                try {
                    int idlePercent = Integer.parseInt(token.substring(2));
                    if (idlePercent < 0 || idlePercent > 100) continue;
                    header.setIdlePercent((byte)idlePercent);
                }
                catch (NumberFormatException ignored) {}
                continue;
            }
            if (token.startsWith("b=")) {
                try {
                    int busyPercent = Integer.parseInt(token.substring(2));
                    if (busyPercent < 0 || busyPercent > 100) continue;
                    header.setBusyPercent((byte)busyPercent);
                }
                catch (NumberFormatException ignored) {}
                continue;
            }
            if (!token.startsWith("app=") || (app = token.substring(4).trim()).isEmpty()) continue;
            header.setApp(app);
        }
    }

    ProxyTimeUnit getNginxUnit() {
        return this.nginxUnit;
    }

    ProxyTimeUnit getApacheUnit() {
        return this.apacheUnit;
    }

    ProxyTimeUnit getAppUnit() {
        return this.appUnit;
    }

    private static class AppTimeUnit
    implements ProxyTimeUnit {
        private AppTimeUnit() {
        }

        @Override
        public long toReceivedTimeMillis(String value) {
            if (value == null) {
                return 0L;
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }

        @Override
        public int toDurationTimeMicros(String value) {
            return 0;
        }
    }

    private static class ApacheTimeUnit
    implements ProxyTimeUnit {
        private ApacheTimeUnit() {
        }

        @Override
        public long toReceivedTimeMillis(String value) {
            if (value == null) {
                return 0L;
            }
            int length = value.length();
            if (length > 3) {
                try {
                    return Long.parseLong(value.substring(0, length - 3));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0L;
        }

        @Override
        public int toDurationTimeMicros(String value) {
            if (value == null) {
                return 0;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
    }

    private static class NginxTimeUnit
    implements ProxyTimeUnit {
        @Override
        public long toReceivedTimeMillis(String value) {
            if (value == null) {
                return 0L;
            }
            int length = value.length();
            int millisPosition = value.lastIndexOf(46);
            if (millisPosition != -1) {
                if (length - millisPosition != 4) {
                    return 0L;
                }
                try {
                    return Long.parseLong(value.substring(0, millisPosition) + value.substring(millisPosition + 1));
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            return 0L;
        }

        @Override
        public int toDurationTimeMicros(String value) {
            if (value == null) {
                return 0;
            }
            int length = value.length();
            int millisPosition = value.lastIndexOf(46);
            if (millisPosition != -1) {
                if (length - millisPosition != 4) {
                    return 0;
                }
                try {
                    return Integer.parseInt(value.substring(0, millisPosition) + value.substring(millisPosition + 1)) * 1000;
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            return 0;
        }
    }

    static interface ProxyTimeUnit {
        public long toReceivedTimeMillis(String var1);

        public int toDurationTimeMicros(String var1);
    }
}

