/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.PackageBasedMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.PackageInternalNameMatcherOperand;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;

@InterfaceStability.Unstable
public class DefaultPackageBasedMatcher
implements PackageBasedMatcher {
    private final String basePackageName;
    private final MatcherOperand matcherOperand;

    DefaultPackageBasedMatcher(String basePackageName) {
        this(basePackageName, null);
    }

    DefaultPackageBasedMatcher(String basePackageName, MatcherOperand additional) {
        Assert.requireNonNull(basePackageName, "basePackageName must not be null");
        if (!StringUtils.hasText(basePackageName)) {
            throw new IllegalArgumentException("basePackageName must not be empty");
        }
        this.basePackageName = basePackageName;
        MatcherOperand operand = new PackageInternalNameMatcherOperand(basePackageName);
        if (additional != null) {
            operand = operand.and(additional);
        }
        this.matcherOperand = operand;
    }

    @Override
    public String getBasePackageName() {
        return this.basePackageName;
    }

    @Override
    public MatcherOperand getMatcherOperand() {
        return this.matcherOperand;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultPackageBasedMatcher{");
        sb.append("basePackageName='").append(this.basePackageName).append('\'');
        sb.append(", matcherOperand=").append(this.matcherOperand);
        sb.append('}');
        return sb.toString();
    }
}

