/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift.interceptor.tprotocol.client;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.thrift.ThriftHeader;
import com.navercorp.pinpoint.plugin.thrift.ThriftRequestProperty;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class TProtocolWriteFieldStopInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final InterceptorScope scope;

    public TProtocolWriteFieldStopInterceptor(InterceptorScope scope) {
        this.scope = scope;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (target instanceof TProtocol) {
            TProtocol oprot = (TProtocol)target;
            try {
                this.appendParentTraceInfo(oprot);
            }
            catch (Throwable t) {
                this.logger.warn("problem writing trace info", t);
            }
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
    }

    private void appendParentTraceInfo(TProtocol oprot) throws TException {
        InterceptorScopeInvocation currentTransaction = this.scope.getCurrentInvocation();
        ThriftRequestProperty parentTraceInfo = (ThriftRequestProperty)currentTransaction.getAttachment();
        if (parentTraceInfo == null) {
            return;
        }
        boolean shouldSample = parentTraceInfo.shouldSample(true);
        if (!shouldSample) {
            parentTraceInfo.writeTraceHeader(ThriftHeader.THRFIT_SAMPLED, oprot);
            return;
        }
        parentTraceInfo.writeTraceHeader(ThriftHeader.THRIFT_TRACE_ID, oprot);
        parentTraceInfo.writeTraceHeader(ThriftHeader.THRIFT_SPAN_ID, oprot);
        parentTraceInfo.writeTraceHeader(ThriftHeader.THRIFT_PARENT_SPAN_ID, oprot);
        parentTraceInfo.writeTraceHeader(ThriftHeader.THRIFT_FLAGS, oprot);
        parentTraceInfo.writeTraceHeader(ThriftHeader.THRIFT_PARENT_APPLICATION_NAME, oprot);
        parentTraceInfo.writeTraceHeader(ThriftHeader.THRIFT_PARENT_APPLICATION_TYPE, oprot);
        parentTraceInfo.writeTraceHeader(ThriftHeader.THRIFT_HOST, oprot);
    }
}

