/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.kafka.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanRecursiveAroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.sampler.SamplingFlagUtils;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.kafka.KafkaConstants;
import com.navercorp.pinpoint.plugin.kafka.descriptor.EntryPointMethodDescriptor;
import com.navercorp.pinpoint.plugin.kafka.field.accessor.RemoteAddressFieldAccessor;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class ConsumerRecordEntryPointInterceptor
extends SpanRecursiveAroundInterceptor {
    protected static final String SCOPE_NAME = "##KAFKA_ENTRY_POINT_START_TRACE";
    protected static final EntryPointMethodDescriptor ENTRY_POINT_METHOD_DESCRIPTOR = new EntryPointMethodDescriptor();
    private final AtomicReference<TraceFactoryProvider.TraceFactory> tracyFactoryReference = new AtomicReference();
    protected final int parameterIndex;

    public ConsumerRecordEntryPointInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, int parameterIndex) {
        super(traceContext, methodDescriptor, SCOPE_NAME);
        traceContext.cacheApi((MethodDescriptor)ENTRY_POINT_METHOD_DESCRIPTOR);
        this.parameterIndex = parameterIndex;
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        recorder.recordServiceType(KafkaConstants.KAFKA_CLIENT_INTERNAL);
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordApi(this.methodDescriptor);
        recorder.recordException(throwable);
    }

    protected Trace createTrace(Object target, Object[] args) {
        ConsumerRecord consumerRecord = this.getConsumerRecord(args);
        if (consumerRecord == null) {
            return null;
        }
        Trace newTrace = this.createTrace(consumerRecord);
        return newTrace;
    }

    private ConsumerRecord getConsumerRecord(Object[] args) {
        Object consumerRecord = this.getTargetParameter(args);
        if (consumerRecord instanceof ConsumerRecord) {
            return (ConsumerRecord)consumerRecord;
        }
        return null;
    }

    protected Object getTargetParameter(Object[] args) {
        if (args == null || args.length <= this.parameterIndex) {
            return null;
        }
        return args[this.parameterIndex];
    }

    private Trace createTrace(ConsumerRecord consumerRecord) {
        TraceFactoryProvider.TraceFactory createTrace = this.tracyFactoryReference.get();
        if (createTrace == null) {
            createTrace = TraceFactoryProvider.get(consumerRecord);
            this.tracyFactoryReference.compareAndSet(null, createTrace);
        }
        return createTrace.createTrace(this.traceContext, consumerRecord);
    }

    private static class TraceFactoryProvider {
        private TraceFactoryProvider() {
        }

        private static TraceFactory get(Object object) {
            try {
                Class<?> aClass = object.getClass();
                Method method = aClass.getMethod("headers", new Class[0]);
                if (method != null) {
                    return new SupportContinueTraceFactory();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return new DefaultTraceFactory();
        }

        private static class SupportContinueTraceFactory
        extends DefaultTraceFactory {
            private SupportContinueTraceFactory() {
            }

            @Override
            public Trace createTrace(TraceContext traceContext, ConsumerRecord consumerRecord) {
                Headers headers = consumerRecord.headers();
                if (headers == null) {
                    return null;
                }
                if (!this.isSampled(headers)) {
                    Trace trace = traceContext.disableSampling();
                    if (this.isDebug) {
                        this.logger.debug("remotecall sampling flag found. skip trace");
                    }
                    return trace;
                }
                TraceId traceId = this.populateTraceIdFromHeaders(traceContext, headers);
                if (traceId != null) {
                    return this.createContinueTrace(traceContext, consumerRecord, traceId);
                }
                return this.createTrace0(traceContext, consumerRecord);
            }

            private boolean isSampled(Headers headers) {
                Header sampledHeader = headers.lastHeader(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_SAMPLED.toString());
                if (sampledHeader == null) {
                    return true;
                }
                String sampledFlag = new String(sampledHeader.value(), KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET);
                return SamplingFlagUtils.isSamplingFlag((String)sampledFlag);
            }

            private TraceId populateTraceIdFromHeaders(TraceContext traceContext, Headers headers) {
                String transactionId = null;
                String spanID = null;
                String parentSpanID = null;
                String flags = null;
                for (Header header : headers.toArray()) {
                    if (header.key().equals(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_TRACE_ID.toString())) {
                        transactionId = new String(header.value(), KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET);
                        continue;
                    }
                    if (header.key().equals(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_PARENT_SPAN_ID.toString())) {
                        parentSpanID = new String(header.value(), KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET);
                        continue;
                    }
                    if (header.key().equals(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_SPAN_ID.toString())) {
                        spanID = new String(header.value(), KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET);
                        continue;
                    }
                    if (!header.key().equals(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_FLAGS.toString())) continue;
                    flags = new String(header.value(), KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET);
                }
                if (transactionId == null || spanID == null || parentSpanID == null || flags == null) {
                    return null;
                }
                TraceId traceId = traceContext.createTraceId(transactionId, Long.parseLong(parentSpanID), Long.parseLong(spanID), Short.parseShort(flags));
                return traceId;
            }

            private Trace createContinueTrace(TraceContext traceContext, ConsumerRecord consumerRecord, TraceId traceId) {
                if (this.isDebug) {
                    this.logger.debug("TraceID exist. continue trace. traceId:{}", (Object)traceId);
                }
                Trace trace = traceContext.continueTraceObject(traceId);
                String parentApplicationName = null;
                String parentApplicationType = null;
                Headers headers = consumerRecord.headers();
                for (Header header : headers.toArray()) {
                    if (header.key().equals(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_PARENT_APPLICATION_NAME.toString())) {
                        parentApplicationName = new String(header.value(), KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET);
                        continue;
                    }
                    if (!header.key().equals(com.navercorp.pinpoint.bootstrap.context.Header.HTTP_PARENT_APPLICATION_TYPE.toString())) continue;
                    parentApplicationType = new String(header.value(), KafkaConstants.DEFAULT_PINPOINT_HEADER_CHARSET);
                }
                if (trace.canSampled()) {
                    SpanRecorder recorder = trace.getSpanRecorder();
                    this.recordRootSpan(recorder, consumerRecord, parentApplicationName, parentApplicationType);
                }
                return trace;
            }
        }

        private static class DefaultTraceFactory
        implements TraceFactory {
            final PLogger logger = PLoggerFactory.getLogger(this.getClass());
            final boolean isDebug = this.logger.isDebugEnabled();

            private DefaultTraceFactory() {
            }

            @Override
            public Trace createTrace(TraceContext traceContext, ConsumerRecord consumerRecord) {
                return this.createTrace0(traceContext, consumerRecord);
            }

            Trace createTrace0(TraceContext traceContext, ConsumerRecord consumerRecord) {
                Trace trace = traceContext.newTraceObject();
                if (trace.canSampled()) {
                    SpanRecorder recorder = trace.getSpanRecorder();
                    this.recordRootSpan(recorder, consumerRecord);
                    if (this.isDebug) {
                        this.logger.debug("TraceID not exist. start new trace.");
                    }
                    return trace;
                }
                if (this.isDebug) {
                    this.logger.debug("TraceID not exist. camSampled is false. skip trace.");
                }
                return null;
            }

            void recordRootSpan(SpanRecorder recorder, ConsumerRecord consumerRecord) {
                this.recordRootSpan(recorder, consumerRecord, null, null);
            }

            void recordRootSpan(SpanRecorder recorder, ConsumerRecord consumerRecord, String parentApplicationName, String parentApplicationType) {
                recorder.recordServiceType(KafkaConstants.KAFKA_CLIENT);
                recorder.recordApi((MethodDescriptor)ENTRY_POINT_METHOD_DESCRIPTOR);
                String remoteAddress = this.getRemoteAddress(consumerRecord);
                recorder.recordEndPoint(remoteAddress);
                recorder.recordRemoteAddress(remoteAddress);
                String topic = consumerRecord.topic();
                recorder.recordRpcName(this.createRpcName(consumerRecord));
                recorder.recordAcceptorHost(remoteAddress);
                recorder.recordAttribute(KafkaConstants.KAFKA_TOPIC_ANNOTATION_KEY, topic);
                recorder.recordAttribute(KafkaConstants.KAFKA_PARTITION_ANNOTATION_KEY, consumerRecord.partition());
                recorder.recordAttribute(KafkaConstants.KAFKA_OFFSET_ANNOTATION_KEY, (Object)consumerRecord.offset());
                if (StringUtils.hasText((String)parentApplicationName) && StringUtils.hasText((String)parentApplicationType)) {
                    recorder.recordParentApplication(parentApplicationName, NumberUtils.parseShort((String)parentApplicationType, (short)ServiceType.UNDEFINED.getCode()));
                }
            }

            private String getRemoteAddress(Object remoteAddressFieldAccessor) {
                String remoteAddress = null;
                if (remoteAddressFieldAccessor instanceof RemoteAddressFieldAccessor) {
                    remoteAddress = ((RemoteAddressFieldAccessor)remoteAddressFieldAccessor)._$PINPOINT$_getRemoteAddress();
                }
                if (StringUtils.isEmpty(remoteAddress)) {
                    return "Unknown";
                }
                return remoteAddress;
            }

            private String createRpcName(ConsumerRecord consumerRecord) {
                StringBuilder rpcName = new StringBuilder("kafka://");
                rpcName.append("topic=").append(consumerRecord.topic());
                rpcName.append("?partition=").append(consumerRecord.partition());
                rpcName.append("&offset=").append(consumerRecord.offset());
                return rpcName.toString();
            }
        }

        private static interface TraceFactory {
            public Trace createTrace(TraceContext var1, ConsumerRecord var2);
        }
    }
}

