/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.beans.interceptor;

import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.spring.beans.SpringBeansTargetScope;
import com.navercorp.pinpoint.plugin.spring.beans.interceptor.TargetBeanFilter;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinitionHolder;

public class ClassPathDefinitionScannerDoScanInterceptor
implements AroundInterceptor {
    protected final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    private final ClassLoader classLoader;
    private final Instrumentor instrumentor;
    private final TransformCallback transformer;
    private final TargetBeanFilter filter;

    public ClassPathDefinitionScannerDoScanInterceptor(Instrumentor instrumentor, ClassLoader classLoader, TransformCallback transformer, TargetBeanFilter filter) {
        this.classLoader = classLoader;
        this.instrumentor = instrumentor;
        this.transformer = transformer;
        this.filter = filter;
    }

    public void before(Object target, Object[] args) {
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        block4: {
            if (result == null || throwable != null || !(result instanceof Set)) {
                return;
            }
            try {
                Set set = (Set)result;
                for (Object o : set) {
                    BeanDefinitionHolder beanDefinitionHolder;
                    if (!(o instanceof BeanDefinitionHolder) || !this.filter.isTarget(SpringBeansTargetScope.COMPONENT_SCAN, (beanDefinitionHolder = (BeanDefinitionHolder)o).getBeanName(), beanDefinitionHolder.getBeanDefinition())) continue;
                    String className = beanDefinitionHolder.getBeanDefinition().getBeanClassName();
                    this.instrumentor.transform(this.classLoader, className, this.transformer);
                    this.filter.addTransformed(className);
                }
            }
            catch (Throwable t) {
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn("AFTER. Caused:{}", (Object)t.getMessage(), (Object)t);
            }
        }
    }
}

