/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.io.header.v1;

import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.header.InvalidHeaderException;

public final class HeaderV1
implements Header {
    public static final byte VERSION = 16;
    private final short type;

    public HeaderV1(byte signature, byte version, short type) {
        if (signature != -17) {
            throw new InvalidHeaderException("invalid signature " + signature);
        }
        if (version != 16) {
            throw new InvalidHeaderException("invalid version " + version);
        }
        this.type = type;
    }

    public HeaderV1(short type) {
        this.type = type;
    }

    @Override
    public byte getSignature() {
        return -17;
    }

    @Override
    public byte getVersion() {
        return 16;
    }

    @Override
    public short getType() {
        return this.type;
    }

    public String toString() {
        return "Header{signature=-17, version=16, type=" + this.type + '}';
    }
}

