/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.io.header;

import com.navercorp.pinpoint.common.buffer.AutomaticBuffer;
import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.header.HeaderEntity;
import com.navercorp.pinpoint.io.header.HeaderWriter;
import com.navercorp.pinpoint.io.header.InvalidHeaderException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.thrift.TException;

public class ByteArrayHeaderWriter
implements HeaderWriter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Header header;
    private final AutomaticBuffer buffer;
    private final HeaderEntity headerEntity;

    public ByteArrayHeaderWriter(Header header) {
        if (header == null) {
            throw new NullPointerException("header must not be null.");
        }
        this.buffer = new AutomaticBuffer(4);
        this.header = header;
        this.headerEntity = HeaderEntity.EMPTY_HEADER_ENTITY;
    }

    public ByteArrayHeaderWriter(Header header, HeaderEntity headerEntity) {
        if (header == null) {
            throw new NullPointerException("header must not be null.");
        }
        this.buffer = new AutomaticBuffer(4);
        this.header = header;
        this.headerEntity = headerEntity;
    }

    @Override
    public byte[] writeHeader() {
        block4: {
            byte version = this.header.getVersion();
            try {
                if (version == 16) {
                    this.writeHeaderV1();
                    break block4;
                }
                if (version == 32) {
                    this.writeHeaderV2();
                    break block4;
                }
                throw new InvalidHeaderException("can not find header version. header : " + this.header);
            }
            catch (Exception e) {
                throw new InvalidHeaderException("can not write header. header : " + this.header, e);
            }
        }
        return this.buffer.getBuffer();
    }

    private void writeHeaderV1() throws TException {
        this.writeHeaderPrefix();
    }

    private void writeHeaderPrefix() {
        this.buffer.putByte(this.header.getSignature());
        this.buffer.putByte(this.header.getVersion());
        this.buffer.putShort(this.header.getType());
    }

    private void writeHeaderV2() throws TException, UnsupportedEncodingException {
        this.writeHeaderPrefix();
        this.writeHeaderEntity();
    }

    private void writeHeaderEntity() throws TException, UnsupportedEncodingException {
        Map<String, String> headerEntityData = this.headerEntity.getEntityAll();
        int size = headerEntityData.size();
        if (size >= 64) {
            throw new InvalidHeaderException("header size is to big. size : " + size);
        }
        this.buffer.putShort((short)size);
        if (size == 0) {
            return;
        }
        for (Map.Entry<String, String> entry : headerEntityData.entrySet()) {
            this.writeString(entry.getKey());
            this.writeString(entry.getValue());
        }
    }

    private void writeString(String value) {
        if (!this.validCheck(value)) {
            throw new InvalidHeaderException("string length is invalid in header data. value : " + value);
        }
        byte[] valueBytes = value.getBytes(UTF_8);
        this.buffer.put2PrefixedBytes(valueBytes);
    }

    private boolean validCheck(String value) {
        int length = value.length();
        return length <= 1024 && length != 0;
    }
}

