/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.cassandra.interceptor;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Statement;
import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.ParsingResult;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue.BindValueUtils;
import com.navercorp.pinpoint.common.util.MapUtils;
import com.navercorp.pinpoint.plugin.cassandra.field.WrappedStatementGetter;
import java.util.HashMap;
import java.util.Map;

public class CassandraStatementExecuteQueryInterceptor
implements AroundInterceptor {
    private static final int DEFAULT_BIND_VALUE_LENGTH = 1024;
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final MethodDescriptor descriptor;
    private final TraceContext traceContext;
    private final int maxSqlBindValueLength;

    public CassandraStatementExecuteQueryInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this(traceContext, descriptor, 1024);
    }

    public CassandraStatementExecuteQueryInterceptor(TraceContext traceContext, MethodDescriptor descriptor, int maxSqlBindValueLength) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        this.maxSqlBindValueLength = maxSqlBindValueLength;
    }

    public void before(Object target, Object[] args) {
        block11: {
            Trace trace;
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if ((trace = this.traceContext.currentTraceObject()) == null) {
                return;
            }
            SpanEventRecorder recorder = trace.traceBlockBegin();
            try {
                DatabaseInfo databaseInfo;
                DatabaseInfo databaseInfo2 = databaseInfo = target instanceof DatabaseInfoAccessor ? ((DatabaseInfoAccessor)target)._$PINPOINT$_getDatabaseInfo() : null;
                if (databaseInfo == null) {
                    databaseInfo = UnKnownDatabaseInfo.INSTANCE;
                }
                recorder.recordServiceType(databaseInfo.getExecuteQueryType());
                recorder.recordEndPoint(databaseInfo.getMultipleHost());
                recorder.recordDestinationId(databaseInfo.getDatabaseId());
                String sql = this.retrieveSql(args[0]);
                if (sql != null) {
                    ParsingResult parsingResult = this.traceContext.parseSql(sql);
                    if (parsingResult != null) {
                        ((ParsingResultAccessor)target)._$PINPOINT$_setParsingResult(parsingResult);
                    } else if (this.logger.isErrorEnabled()) {
                        this.logger.error("sqlParsing fail. parsingResult is null sql:{}", (Object)sql);
                    }
                    Map bindValue = ((BindValueAccessor)target)._$PINPOINT$_getBindValue();
                    if (MapUtils.hasLength((Map)bindValue)) {
                        String bindString = this.toBindVariable(bindValue);
                        recorder.recordSqlParsingResult(parsingResult, bindString);
                    } else {
                        recorder.recordSqlParsingResult(parsingResult);
                    }
                }
                recorder.recordApi(this.descriptor);
                this.clean(target);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block11;
                this.logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String retrieveSql(Object args0) {
        if (args0 instanceof BoundStatement) {
            return ((BoundStatement)args0).preparedStatement().getQueryString();
        }
        if (args0 instanceof RegularStatement) {
            return ((RegularStatement)args0).getQueryString();
        }
        if (args0 instanceof WrappedStatementGetter) {
            return this.retrieveWrappedStatement((WrappedStatementGetter)args0);
        }
        if (args0 instanceof BatchStatement) {
            return null;
        }
        if (args0 instanceof String) {
            return (String)args0;
        }
        return null;
    }

    private String retrieveWrappedStatement(WrappedStatementGetter wrappedStatementGetter) {
        Statement wrappedStatement = wrappedStatementGetter._$PINPOINT$_getStatement();
        return this.retrieveSql(wrappedStatement);
    }

    private void clean(Object target) {
        if (target instanceof BindValueAccessor) {
            ((BindValueAccessor)target)._$PINPOINT$_setBindValue(new HashMap());
        }
    }

    private String toBindVariable(Map<Integer, String> bindValue) {
        return BindValueUtils.bindValueToString(bindValue, (int)this.maxSqlBindValueLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordException(throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

