/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.oracle.parser;

import com.navercorp.pinpoint.plugin.jdbc.oracle.parser.DriverType;
import com.navercorp.pinpoint.plugin.jdbc.oracle.parser.KeyValue;
import com.navercorp.pinpoint.plugin.jdbc.oracle.parser.OracleConnectionStringException;
import com.navercorp.pinpoint.plugin.jdbc.oracle.parser.OracleNetConnectionDescriptorTokenizer;
import com.navercorp.pinpoint.plugin.jdbc.oracle.parser.Token;

public class OracleNetConnectionDescriptorParser {
    private static String THIN = "jdbc:oracle:thin";
    private static String OCI = "jdbc:oracle:oci";
    private String url;
    private String normalizedUrl;
    private DriverType driverType;
    private OracleNetConnectionDescriptorTokenizer tokenizer;

    public OracleNetConnectionDescriptorParser(String url) {
        this.url = url;
        this.normalizedUrl = url.toLowerCase();
        this.tokenizer = new OracleNetConnectionDescriptorTokenizer(this.normalizedUrl);
    }

    public KeyValue parse() {
        int position;
        if (this.normalizedUrl.startsWith(THIN)) {
            position = this.nextPosition(THIN);
            this.driverType = DriverType.THIN;
        } else if (this.normalizedUrl.startsWith(OCI)) {
            position = this.nextPosition(OCI);
            this.driverType = DriverType.OCI;
        } else {
            throw new IllegalArgumentException("invalid oracle jdbc url. expected token:(" + THIN + " or " + OCI + ") url:" + this.url);
        }
        this.tokenizer.setPosition(position);
        this.tokenizer.parse();
        KeyValue keyValue = this.parseKeyValue();
        this.checkEof();
        return keyValue;
    }

    private void checkEof() {
        Token eof = this.tokenizer.nextToken();
        if (eof == null) {
            throw new OracleConnectionStringException("parsing error. expected token:'EOF' token:null");
        }
        if (eof != OracleNetConnectionDescriptorTokenizer.TOKEN_EOF_OBJECT) {
            throw new OracleConnectionStringException("parsing error. expected token:'EOF' token:" + eof);
        }
    }

    public DriverType getDriverType() {
        return this.driverType;
    }

    private int nextPosition(String driverUrl) {
        int thinLength = driverUrl.length();
        if (this.normalizedUrl.startsWith(":@", thinLength)) {
            return thinLength + 2;
        }
        if (this.normalizedUrl.startsWith("@", thinLength)) {
            return thinLength + 1;
        }
        throw new OracleConnectionStringException("invalid oracle jdbc url:" + driverUrl);
    }

    private KeyValue parseKeyValue() {
        Token token;
        boolean nonTerminalValue;
        KeyValue keyValue;
        block5: {
            Token endCheck;
            this.tokenizer.checkStartToken();
            keyValue = new KeyValue();
            Token literalToken = this.tokenizer.getLiteralToken();
            keyValue.setKey(literalToken.getToken());
            this.tokenizer.checkEqualToken();
            nonTerminalValue = false;
            do {
                if ((token = this.tokenizer.lookAheadToken()) == null) {
                    throw new OracleConnectionStringException("Syntax error. lookAheadToken is null");
                }
                if (token.getType() != 0) break block5;
                nonTerminalValue = true;
                KeyValue child = this.parseKeyValue();
                keyValue.addKeyValueList(child);
            } while ((endCheck = this.tokenizer.lookAheadToken()) != OracleNetConnectionDescriptorTokenizer.TOKEN_KEY_END_OBJECT);
            this.tokenizer.nextPosition();
            return keyValue;
        }
        if (token.getType() == 3) {
            if (nonTerminalValue) {
                throw new OracleConnectionStringException("Syntax error. expected token:'(' or ')' :" + token.getToken());
            }
            this.tokenizer.nextPosition();
            keyValue.setValue(token.getToken());
            this.tokenizer.checkEndToken();
            return keyValue;
        }
        if (token.getType() == 1) {
            this.tokenizer.nextPosition();
            return keyValue;
        }
        throw new OracleConnectionStringException("Syntax error. " + token.getToken());
    }
}

