/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.oracle;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.PreparedStatementBindingMethodFilter;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.jdbc.oracle.OracleConfig;
import com.navercorp.pinpoint.plugin.jdbc.oracle.OracleConstants;
import com.navercorp.pinpoint.plugin.jdbc.oracle.OracleJdbcUrlParser;
import java.security.ProtectionDomain;
import java.util.List;

public class OraclePlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final String ORACLE_SCOPE = "ORACLE_SCOPE";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private static final String CLASS_STATEMENT_WRAPPER = "oracle.jdbc.driver.OracleStatementWrapper";
    private static final String CLASS_STATEMENT = "oracle.jdbc.driver.OracleStatement";
    private static final String CLASS_PREPARED_STATEMENT_WRAPPER = "oracle.jdbc.driver.OraclePreparedStatementWrapper";
    private static final String CLASS_PREPARED_STATEMENT = "oracle.jdbc.driver.OraclePreparedStatement";
    private static final String CLASS_CALLABLE_STATEMENT_WRAPPER = "oracle.jdbc.driver.OracleCallableStatementWrapper";
    private static final String CLASS_CALLABLE_STATEMENT = "oracle.jdbc.driver.OracleCallableStatement";
    private TransformTemplate transformTemplate;
    private final JdbcUrlParserV2 jdbcUrlParser = new OracleJdbcUrlParser();

    public void setup(ProfilerPluginSetupContext context) {
        OracleConfig config = new OracleConfig(context.getConfig());
        if (!config.isPluginEnable()) {
            this.logger.info("Oracle plugin is not executed because plugin enable value is false.");
            return;
        }
        context.addJdbcUrlParser(this.jdbcUrlParser);
        this.addConnectionTransformer(config);
        this.addDriverTransformer();
        this.addPreparedStatementTransformer(config);
        this.addCallableStatementTransformer();
        this.addStatementTransformer();
    }

    private void addConnectionTransformer(final OracleConfig config) {
        this.transformTemplate.transform("oracle.jdbc.driver.PhysicalConnection", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.ConnectionCloseInterceptor", OraclePlugin.ORACLE_SCOPE);
                String statementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                String preparedStatementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "java.lang.String[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", OraclePlugin.ORACLE_SCOPE);
                if (config.isProfileSetAutoCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"setAutoCommit", (String[])new String[]{"boolean"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionSetAutoCommitInterceptor", OraclePlugin.ORACLE_SCOPE);
                }
                if (config.isProfileCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"commit", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionCommitInterceptor", OraclePlugin.ORACLE_SCOPE);
                }
                if (config.isProfileRollback()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"rollback", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionRollbackInterceptor", OraclePlugin.ORACLE_SCOPE);
                }
                return target.toBytecode();
            }
        });
    }

    private void addDriverTransformer() {
        this.transformTemplate.transform("oracle.jdbc.driver.OracleDriver", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"connect", (String[])new String[]{"java.lang.String", "java.util.Properties"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.DriverConnectInterceptorV2", VarArgs.va((Object[])new Object[]{OracleConstants.ORACLE}), OraclePlugin.ORACLE_SCOPE, ExecutionPolicy.ALWAYS);
                return target.toBytecode();
            }
        });
    }

    private void addPreparedStatementTransformer(final OracleConfig config) {
        TransformCallback transformer = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                if (className.equals(OraclePlugin.CLASS_PREPARED_STATEMENT) && instrumentor.exist(loader, OraclePlugin.CLASS_PREPARED_STATEMENT_WRAPPER, protectionDomain)) {
                    return null;
                }
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                int maxBindValueSize = config.getMaxSqlBindValueSize();
                String preparedStatementInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), OraclePlugin.ORACLE_SCOPE);
                if (config.isTraceSqlBindValue()) {
                    PreparedStatementBindingMethodFilter filter = new PreparedStatementBindingMethodFilter();
                    List declaredMethods = target.getDeclaredMethods((MethodFilter)filter);
                    for (InstrumentMethod method : declaredMethods) {
                        method.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementBindVariableInterceptor", OraclePlugin.ORACLE_SCOPE);
                    }
                }
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform(CLASS_PREPARED_STATEMENT, transformer);
        this.transformTemplate.transform(CLASS_PREPARED_STATEMENT_WRAPPER, transformer);
    }

    private void addCallableStatementTransformer() {
        TransformCallback transformer = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (className.equals(OraclePlugin.CLASS_CALLABLE_STATEMENT) && instrumentor.exist(loader, OraclePlugin.CLASS_CALLABLE_STATEMENT_WRAPPER, protectionDomain)) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                String callableStatementInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", OraclePlugin.ORACLE_SCOPE);
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform(CLASS_CALLABLE_STATEMENT, transformer);
        this.transformTemplate.transform(CLASS_CALLABLE_STATEMENT_WRAPPER, transformer);
    }

    private void addStatementTransformer() {
        TransformCallback transformer = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                if (className.equals(OraclePlugin.CLASS_STATEMENT) && instrumentor.exist(loader, OraclePlugin.CLASS_STATEMENT_WRAPPER, protectionDomain)) {
                    return null;
                }
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                String executeQueryInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor", OraclePlugin.ORACLE_SCOPE);
                String executeUpdateInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", OraclePlugin.ORACLE_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", OraclePlugin.ORACLE_SCOPE);
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform(CLASS_STATEMENT, transformer);
        this.transformTemplate.transform(CLASS_STATEMENT_WRAPPER, transformer);
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

