/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.google.httpclient.interceptor;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.google.httpclient.HttpClientConstants;

public class HttpRequestExecuteAsyncMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;
    private final InterceptorScope interceptorScope;

    public HttpRequestExecuteAsyncMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.interceptorScope = interceptorScope;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        try {
            AsyncContext asyncContext = recorder.recordNextAsyncContext();
            InterceptorScopeInvocation transaction = this.interceptorScope.getCurrentInvocation();
            if (transaction != null) {
                transaction.setAttachment((Object)asyncContext);
                if (this.isDebug) {
                    this.logger.debug("Set AsyncContext {}", (Object)asyncContext);
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to before process. {}", (Object)t.getMessage(), (Object)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.methodDescriptor);
            recorder.recordServiceType(HttpClientConstants.HTTP_CLIENT_INTERNAL);
            recorder.recordException(throwable);
            InterceptorScopeInvocation transaction = this.interceptorScope.getCurrentInvocation();
            if (transaction != null) {
                transaction.removeAttachment();
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

