/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet;

import com.navercorp.pinpoint.rpc.packet.BasicPacket;
import com.navercorp.pinpoint.rpc.packet.PayloadPacket;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class RequestPacket
extends BasicPacket {
    private final int requestId;

    public RequestPacket(int requestId, byte[] payload) {
        super(payload);
        this.requestId = requestId;
    }

    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public short getPacketType() {
        return 5;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer((int)10);
        header.writeShort(5);
        header.writeInt(this.requestId);
        return PayloadPacket.appendPayload(header, this.payload);
    }

    public static RequestPacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 5);
        if (buffer.readableBytes() < 8) {
            buffer.resetReaderIndex();
            return null;
        }
        int messageId = buffer.readInt();
        ChannelBuffer payload = PayloadPacket.readPayload(buffer);
        if (payload == null) {
            return null;
        }
        RequestPacket requestPacket = new RequestPacket(messageId, payload.array());
        return requestPacket;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestPacket");
        sb.append("{requestId=").append(this.requestId);
        sb.append(", ");
        if (this.payload == null) {
            sb.append("payload=null");
        } else {
            sb.append("payloadLength=").append(this.payload.length);
        }
        sb.append('}');
        return sb.toString();
    }
}

