/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet;

import com.navercorp.pinpoint.rpc.packet.BasicPacket;
import com.navercorp.pinpoint.rpc.packet.PayloadPacket;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class ControlHandshakeResponsePacket
extends BasicPacket {
    public static final String CODE = "code";
    public static final String SUB_CODE = "subCode";
    public static final String CLUSTER = "cluster";
    private final int requestId;

    public ControlHandshakeResponsePacket(int requestId, byte[] payload) {
        super(payload);
        this.requestId = requestId;
    }

    @Override
    public short getPacketType() {
        return 151;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer((int)10);
        header.writeShort(151);
        header.writeInt(this.requestId);
        return PayloadPacket.appendPayload(header, this.payload);
    }

    public static ControlHandshakeResponsePacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 151);
        if (buffer.readableBytes() < 8) {
            buffer.resetReaderIndex();
            return null;
        }
        int messageId = buffer.readInt();
        ChannelBuffer payload = PayloadPacket.readPayload(buffer);
        if (payload == null) {
            return null;
        }
        ControlHandshakeResponsePacket helloPacket = new ControlHandshakeResponsePacket(messageId, payload.array());
        return helloPacket;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{requestId=").append(this.requestId);
        sb.append(", ");
        if (this.payload == null) {
            sb.append("payload=null");
        } else {
            sb.append("payloadLength=").append(this.payload.length);
        }
        sb.append('}');
        return sb.toString();
    }
}

