/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.common;

public class CyclicStateChecker {
    private final byte conditionValue;
    private final int capacity;
    private byte data = 0;
    private int index = 0;

    public CyclicStateChecker(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity + ". Available 1 ~ 8.");
        }
        if (capacity > 8) {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity + ". Available 1 ~ 8.");
        }
        int conditionValue = 0;
        for (int i = 0; i < capacity; ++i) {
            conditionValue = (byte)(conditionValue | 1 << i);
        }
        this.capacity = capacity;
        this.conditionValue = (byte)conditionValue;
    }

    public boolean markAndCheckCondition() {
        ++this.index;
        this.index %= this.capacity;
        this.data = (byte)(this.data | 1 << this.index);
        return this.data == this.conditionValue;
    }

    public void unmark() {
        ++this.index;
        this.index %= this.capacity;
        this.data = (byte)(this.data & this.conditionValue - (1 << this.index));
    }

    public boolean checkCondition() {
        return this.data == this.conditionValue;
    }
}

